/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.com.xmlbeans;

import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;

import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TestXmlBeans {

    public void compile() {

        //first get the Xmlschema Object
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            Definition wsdlDefinition = wsdlReader.readWSDL("test.wsdl");

            //schema list for that wsdl
            List schemaList = wsdlDefinition.getTypes().getExtensibilityElements();

            // conver to xmlobject list
            List xmlObjectList = new ArrayList();
            XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();

            Schema schema;
            XmlSchema xmlSchema;
            for (Iterator iter = schemaList.iterator(); iter.hasNext();) {
                schema = (Schema) iter.next();
                xmlSchema = xmlSchemaCollection.read(schema.getElement(), null);
                xmlObjectList.add(XmlObject.Factory.parse(getSchemaAsString(xmlSchema)));
            }

            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setEntityResolver(new TestEntityResolver());

            // compile the schema list using the xmlbeans class
            XmlObject[] xmlObjectArray = (XmlObject[]) xmlObjectList.toArray(new XmlObject[xmlObjectList.size()]);

            XmlBeans.compileXmlBeans(
                    null,
                    null,
                    xmlObjectArray,
                    null,
                    XmlBeans.typeLoaderForClassLoader(SchemaDocument.class.getClassLoader()),
                    new TestFiler(),
                    xmlOptions);
            System.out.println("OK");

        } catch (WSDLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        } catch (XmlException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }


    }

    private static String getSchemaAsString(XmlSchema schema) throws IOException {
        StringWriter writer = new StringWriter();
        schema.write(writer);
        return writer.toString();
    }

    public static void main(String[] args) {
        new TestXmlBeans().compile();
    }


}
