
#include <stdlib.h>
#include <stdio.h>
#include <mpi.h>
#include <string.h>

struct double3
{
	double x, y, z;
};

int 
main(int argc, char** argv)
{
	int		myrank, numprocs;
	MPI_Win		win;
	void*		mem;
	MPI_Datatype	mpi_double3, mpit;
	
	MPI_Init(&argc,&argv);
	
	MPI_Comm_rank(MPI_COMM_WORLD,&myrank  );
	MPI_Comm_size(MPI_COMM_WORLD,&numprocs);
	
	MPI_Type_contiguous(3, MPI_DOUBLE, &mpi_double3);
	MPI_Type_commit(&mpi_double3);
	
	MPI_Alloc_mem(10*sizeof(double3), MPI_INFO_NULL, &mem);
	memset(mem, 0x0, 10*sizeof(double3));
	
	MPI_Win_create(mem, 10*sizeof(double3), sizeof(double3), MPI_INFO_NULL,
		       MPI_COMM_WORLD, &win);
	
	MPI_Win_fence(0, win);
	if(0 == myrank) {
		int displ[4];
		

#ifdef O1 /* Goes wrong */
		displ[0] = 3;
		displ[1] = 2;
		displ[2] = 1;
		displ[3] = 0;
#endif /* O1 */
#ifdef O2
		displ[0] = 0;
		displ[1] = 1;
		displ[2] = 2;
		displ[3] = 3;
#endif /* O2 */

#ifdef V1
		MPI_Type_create_indexed_block(4, 1, displ, mpi_double3, &mpit);
#endif /* V1 */
#ifdef V2
		MPI_Type_contiguous(4, mpi_double3, &mpit);
#endif /* V2 */
		MPI_Type_commit(&mpit);
		
		((double3* )mem)[0].x =  5.;
		((double3* )mem)[1].z = -1.;
		
#ifdef ONESIDED
		MPI_Put(mem, 4, mpi_double3, 1, 0, 1, mpit, win);
#else
		MPI_Send(mem, 10, mpi_double3, 1, 0, MPI_COMM_WORLD);
#endif /* ONESIDED */
	}
#ifdef ONESIDED
	MPI_Win_fence(0, win);
#endif /* ONESIDED */
	if(1 == myrank) {
#ifdef ONESIDED
#else
		MPI_Recv(mem, 10, mpi_double3, 0, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
#endif /* ONESIDED */
		for(int i = 0; i < 10; ++i) {
			printf("mem[%d] = {%8.4f,%8.4f,%8.4f}\n", i, ((double3* )mem)[i].x, ((double3* )mem)[i].y, ((double3* )mem)[i].z);
		}
	}
	
	MPI_Type_free(&mpi_double3);
	if(0 == myrank) {
		MPI_Type_free(&mpit);
	}
	MPI_Win_free(&win);
	
	MPI_Finalize();
}
