      PROGRAM nf90_test

      USE netcdf
      USE mpi

      implicit none

!     include 'mpif.h'

      integer, parameter :: r8 = selected_real_kind(12,300)    ! 64-bit

      logical :: Master
      logical :: Done = .FALSE.
      logical :: Report = .FALSE.

      integer :: Lstr, MyError, MyRank, Nnodes, i, comm
      integer :: access, dimid, ncformat, ncid, status, varid(2)
      integer :: Imax, Jmax, LBi, UBi

      integer :: info =  MPI_INFO_NULL

      real(r8), allocatable :: A1d(:), B1d(:)

      character (len=40) :: ncname

      character (len=MPI_MAX_ERROR_STRING) :: string
!
!  Set output file name.
!
      ncname='nf90_test.nc'

      DO WHILE (.not.Done)
!
!  Initialize MPI.
!
        CALL mpi_init (MyError)
        IF (MyError.ne.MPI_SUCCESS) THEN
          !CALL mpi_error_string (MyError, string, Lstr)
          PRINT *, 'Unable to initialize MPI.'
          PRINT *, string(1:Lstr)
          EXIT
        END IF
! added for ompi stuff
!       comm=ompi_mpi_comm_world
!       comm=MPI_COMM_WORLD
!
!  Get rank of the local process in the group associated with the
!  communicator.
!
        CALL mpi_comm_rank (MPI_COMM_WORLD, MyRank, MyError)
        IF (MyError.ne.MPI_SUCCESS) THEN
!         Commented because mpi_error_string says "Could not resolve
!         generic pocedure  mpi_error_string" when mpi.mod is used.
!         CALL mpi_error_string (MyError, string, Lstr)
          PRINT *, 'Unable to inquire rank of local node.'
          PRINT *, string(1:Lstr)
          EXIT
        END IF
!
!  Get number of processes in the group associated with the
!  communicator.
!
        CALL mpi_comm_size (MPI_COMM_WORLD, Nnodes, MyError)
        IF (MyError.ne.MPI_SUCCESS) THEN
          !CALL mpi_error_string (MyError, string, Lstr)
          PRINT *, 'Unable to inquire of processes in the group.'
          PRINT *, string(1:Lstr)
          EXIT
        END IF
!
!  Identify master node.
!
        Master=.FALSE.
        IF (MyRank.eq.0) THEN
          Master=.TRUE.
        END IF
!
!  Allocate working array.
!
        Imax=100*Nnodes

        LBi=1+MyRank*Imax/Nnodes
        UBi=LBi-1+Imax/Nnodes

        IF (.not.ALLOCATED(A1D)) THEN
          allocate ( A1D(LBi:UBi) )
        END IF
        IF (.not.ALLOCATED(B1D)) THEN
          allocate ( B1D(Imax) )
          B1D = 0.0_r8
        END IF

        DO i=LBi,UBi
          A1D(i)=REAL(i, r8)
        END DO

        IF (Master) THEN
          PRINT *, ' '
          PRINT *, ' *** Writing output file :   ', TRIM(ncname)
        END IF
!
!  Create output NetCDF file.
!
!       status=nf90_create_par(TRIM(ncname),                            &
!    &                         OR(nf90_clobber, nf90_netcdf4),          &
!    &                         comm, info, ncid)
        status=nf90_create_par(TRIM(ncname),                            &
     &                         OR(nf90_clobber, nf90_netcdf4),          &
     &                         MPI_COMM_WORLD, info, ncid)
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to create output file:  ', TRIM(ncname)
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Report) PRINT 10, ' Output ncid = ', ncid, MyRank
        END IF
!
!  Define dimensions.
!
        status=nf90_def_dim(ncid, 'Imax', Imax, dimid)
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Error while defining dimension:  Imax'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Report) PRINT 10, '  Imax dimid = ', dimid, MyRank
        END IF
!
!  Define scalar variable.
!
        status=nf90_def_var(ncid, 'Jmax', nf90_int, varid(1))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to define variable:  Jmax'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Report) PRINT 10, '  Jmax varid = ', varid(1), MyRank
        END IF
!
!  Define independent parallel access. This variable needs to be
!  written by a single parallel node (master). It seems that neither
!  nf_independent or nf90_independent is defined in netcdf.mod;
!  a "access" value of zero only work here. 
!
!       access=nf90_independent
        access=0
        status=nf90_var_par_access(ncid, varid(1), access)  
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to set parallel access for:  Jmax'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        END IF
!
!  Define array variable.
!
        status=nf90_def_var(ncid, 'A1D', nf90_double,                   &
     &                      (/dimid/), varid(2))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to define variable:  A1D'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Report) PRINT 10, '   A1D varid = ', varid(2), MyRank
        END IF
!
!  Define collective parallel access (all threads participate in
!  writing). Again, neither nf_independent or nf90_independent is
!  defined in module netcdf. Any value of "access" work here.
!  Is this a bug or a C-test thing?
!
!       access=nf90_collective
        access=-12345678
        status=nf90_var_par_access(ncid, varid(2), access)
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to set parallel access for:  A1D'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        END IF
!
!  Write out variables.
!
        IF (Master) THEN
          status=nf90_put_var(ncid, varid(1), Imax)
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              PRINT *, 'Error while writing variable:  Jmax'
              PRINT *, nf90_strerror(status)
            END IF
            EXIT
          END IF
        END IF

        status=nf90_put_var(ncid, varid(2), A1D(LBi:),                  &
     &                      start = (/LBi/),                            &
     &                      count = (/UBi-LBi+1/))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Error while writing variable:  A1D'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        END IF
!
!  Close file.
!
        status=nf90_close(ncid)
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to close output file:  ', TRIM(ncname)
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        END IF

        Done=.TRUE.

      END DO      

      Done=.FALSE.

      DO WHILE (.not.Done.and.                                          &
     &          (status.eq.nf90_noerr).and.                             &
     &          (MyError.eq.MPI_SUCCESS))

        IF (Master) THEN
          PRINT *, ' *** Reading input  file :   ', TRIM(ncname)
        END IF

!
!  Open input NetCDF file.
!
        status=nf90_open_par(TRIM(ncname), nf90_nowrite,                &
     &                       MPI_COMM_WORLD, info, ncid)
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to open input file:  ', TRIM(ncname)
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Report) PRINT 10, '  Input ncid = ', ncid, MyRank
        END IF
!
!  Inquire input file format.
!
        status=nf90_inquire(ncid,                                       &
     &                      formatNum = ncformat)
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to inquire file format:  ', TRIM(ncname)
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Master) THEN
            IF (ncformat.eq.nf90_format_classic) THEN
              PRINT *, ' *** Input file format   :   NetCDF-3 Classic'
            ELSE IF (ncformat.eq.nf90_format_64bit) THEN
              PRINT *, ' *** Input file format   :   NetCDF-3 64bit'
            ELSE IF (ncformat.eq.nf90_format_netcdf4) THEN
              PRINT *, ' *** Input file format   :   NetCDF-4'
            ELSE IF (ncformat.eq.nf90_format_netcdf4_classic) THEN
              PRINT *, ' *** Input file format   :   NetCDF-4 Classic'
            ELSE
              PRINT *, ' *** Input file format   :   Unkown'
            END IF
          END IF
        END IF
!
!  Read in variables.
!
        IF (Master) THEN
          status=nf90_inq_varid(ncid, 'Jmax', varid(1))
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              PRINT *, 'Unable to inquire ID for variable:  Jmax'
              PRINT *, nf90_strerror(status)
            END IF
            EXIT
          ELSE
            IF (Report) PRINT 10, '  Jmax varid = ', varid(1), MyRank
          END IF

          status=nf90_get_var(ncid, varid(1), Jmax)
          IF (status.ne.nf90_noerr) THEN
            IF (Master) THEN
              PRINT *, 'Error while writing variable:  Imax'
              PRINT *, nf90_strerror(status)
            END IF
            EXIT
          ELSE
            IF (Report) PRINT 10, '        Jmax = ', Jmax, MyRank
          END IF
        END IF

        status=nf90_inq_varid(ncid, 'A1D', varid(2))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to inquire ID for variable:  A1D'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Report) PRINT 10, '   A1D varid = ', varid(2), MyRank
        END IF

        status=nf90_get_var(ncid, varid(2), B1D(LBi:),                  &
     &                      start = (/LBi/),                            &
     &                      count = (/UBi-LBi+1/))
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Error while writing variable:  B1d'
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        ELSE
          IF (Report) THEN      
            PRINT 20, ' MINVAL(B1D) = ', MINVAL(B1D), MyRank
            PRINT 20, ' MAXVAL(B1D) = ', MAXVAL(B1D), MyRank
          END IF
        END IF
!
!  Close file.
!
        status=nf90_close(ncid)
        IF (status.ne.nf90_noerr) THEN
          IF (Master) THEN
            PRINT *, 'Unable to close input file:  ', TRIM(ncname)
            PRINT *, nf90_strerror(status)
          END IF
          EXIT
        END IF

        Done=.TRUE.

      END DO

!
!  Deallocate.
!
      IF (ALLOCATED(A1D)) THEN
        deallocate ( A1D )
      END IF
      IF (ALLOCATED(B1D)) THEN
        deallocate ( B1D )
      END IF
!
!  Terminate MPI communications
!
      CALL mpi_finalize (MyError)
      IF (MyError.ne.MPI_SUCCESS) THEN
        !CALL mpi_error_string (MyError, string, Lstr)
        PRINT *, 'Unable to finalize MPI.'
        PRINT *, string(1:Lstr)
      END IF

      IF (Master.and.                                                   &
     &     (status.eq.nf90_noerr).and.(MyError.eq.MPI_SUCCESS)) THEN
        PRINT *, ' *** Done Successfully.'
        PRINT *, ' *** ', TRIM(nf90_inq_libvers())
      ENDIF

 10   FORMAT (a, i7, 3x,' Node = ', i3)
 20   FORMAT (a, f7.3, 3x,' Node = ', i3)

      END PROGRAM nf90_test
