/*
        Generic Master Worker Application Template
*/
#include "gmwat.h"
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <assert.h>

#ifndef WIN32
#include <unistd.h>
#endif

#ifdef WIN32
#include <windows.h>
#define usleep(x) Sleep((DWORD)(x/1000.0))
#endif

#ifdef VERBOSE_DATA
#include <string.h>

void printData(char *tag, char *p, int size) {
    char *buf, *sp;

    buf = (char *)malloc(strlen(tag)+64+size*4+16);
    sp = buf;
	sprintf(sp, "\x1b[1;33;44m(%s) [%d]", tag, size);
    sp += strlen(sp);
	while(size--) {
		sprintf(sp, " %d",*p++);
        sp += strlen(sp);
	}
	sprintf(sp, ".\x1b[0m");
    puts(buf);
    free(buf);    
}
#else
#define printData(t, x,y)
#endif

int isc, iss, osc, oss, proc, procd,  maxgi;
void user_config(int argc, char **argv, char **env, int *wu, int *iter, char role) {
    int err=0;

    if (argc==9) {
        *wu = atoi(argv[1]);
        *iter = atoi(argv[2]);
        isc = atoi(argv[3]);
        iss = atoi(argv[4]);
        osc = atoi(argv[5]);
        oss = atoi(argv[6]);
        proc = atoi(argv[7]);
        procd = atoi(argv[8]);

        srand((int)time(NULL));
    } else {
        err=1;
        printf("Error: Invalid parameter number %d, expected 8.\n", argc-1);
    }
    if(!err && (*wu<=0 || isc<=0 || iss<=0 || osc<=0 || oss<=0)) {
        err=1;
        printf("Error: parameters must be non zero numbers.\n");
    }
    if(err) {
        printf("Usage: %s wu iter <input segment count> <input segment size> <output segment count> <output segment size> <proc time> <proc time variation>\n", argv[0]);
        exit(0);
    }
	
	#ifdef API_TRACE
	printf("\x1b[22;30;47m[app_synthetic trace] user_config(%d)\x1b[0m\n", *wu);
	#endif
	
	{
		int i;
		for(i=0;i<8; i++) {
			int maxdiv = (int)pow(2, i);
			if(iss%maxdiv!=0 || iss/maxdiv==0 || oss%maxdiv!=0 || oss/maxdiv==0) {				
				break;
			}
		}
        maxgi=--i;
	}
}

int user_canBreakDown(int gi) {
	if(gi>maxgi) return 0;
    return 2;
}

struct WorkData *user_buildWorkData(int gi, int index, struct WorkData *top, struct WorkData *reuse, int isInput) {
    struct WorkData *ret = NULL;
    int scount, ssize;

    if(isInput) {
        scount = isc;
        ssize = iss/((int)pow(2,gi));
    } else {
        scount = osc;
        ssize = oss/((int)pow(2,gi));
    }

    if(reuse) {
        ret=reuse;
    } else {		
        int i;
        ret = (struct WorkData *)malloc(sizeof(struct WorkData));
        ret->count = scount;
        ret->chunks = (struct DataChunk *)malloc(sizeof(struct DataChunk)*ret->count);
		if(gi==0 || !top) {
			for(i=0; i<ret->count; i++) {
				ret->chunks[i].ident = 0;
				ret->chunks[i].refs = 0;
				ret->chunks[i].size = ssize;
				ret->chunks[i].data = malloc(ret->chunks[i].size);
			}
		} else {
			for(i=0; i<ret->count; i++) {
				ret->chunks[i].ident = 0;
				ret->chunks[i].refs = -1; //virtual
				ret->chunks[i].size = ssize;
			}
            assert(top);
		}
    }

    #ifdef API_TRACE
    printf("\x1b[22;30;47m[app_synthetic trace] user_buildWorkData(%d, %d, %p, %p, %d) = %p\x1b[0m\n", gi, index, top, reuse, isInput, ret);
    #endif

    if(gi>0 && top) {	
		//remap virtual ptrs
		int k, inc;

        for(k=0; k<top->count; k++) {
            printData("user_buildWorkData top", top->chunks[k].data, top->chunks[k].size);
        }
        inc = ((isInput?iss:oss)/((int)pow(2, gi))) * (index % 2);
        for(k=0; k<ret->count; k++) {
            ret->chunks[k].data = (((char *)top->chunks[k].data) + inc);
            printData("user_buildWorkData*", ret->chunks[k].data, ret->chunks[k].size);
        }
        #ifdef VERBOSE_DATA
        printf("\x1b[22;30;47m* remaped (inc %d)\x1b[0m\n", inc);
        #endif
	} else {
        #ifdef DISABLE_CHECK
        int i, k;
        for(k=0; k<ret->size; k++) {
            for(i=0; i<ret->chunks[k].size; i++) {
                ((char *)ret->chunks[k].data)[i] = 0;
            }
            printData("user_buildWorkData", ret->chunks[k].data, ret->chunks[k].size);
        }
        #endif
    }

    return ret;
}

void user_processWorkData(int gi, int index, struct WorkData *input, struct WorkData *output) {
    #ifndef DISABLE_CHECK
    int i, k, div;
    #endif
    int tm;

	#ifdef API_TRACE
	printf("\x1b[22;30;47m[app_synthetic trace] user_processWork(%d, %d, %p, %p)\x1b[0m\n", gi, index, input, output);
	#endif

    #ifndef DISABLE_CHECK
    div = (int)pow(2, gi);
    for(k=0; k<input->count; k++) {
        printData("user_processWork", input->chunks[k].data, input->chunks[k].size);
        for(i=0; i<input->chunks[k].size; i++) {
            char ex = (char)(1+i+k+index*(iss/div))%255;
            if( ((char *)input->chunks[k].data)[i] != ex ) {
                printf("\x1b[1;5;37;41mERROR(user_processWork): Invalid request checking of wn %d, gi %d (pos %d != %d)\x1b[0m\n", index, gi, i, ex);
                exit(0);
            }
        }
    }

    for(k=0; k<output->count; k++) {
        for(i=0; i<output->chunks[k].size; i++) {
			((char *)output->chunks[k].data)[i] = (char)(10+i+k+index*(oss/div))%255;
        }
		printData("user_processWork", output->chunks[k].data, output->chunks[k].size);
    }
    #endif

    tm = (proc + (int)((procd*1.0*rand()/(RAND_MAX+1.0)) - (procd/2.0)))/div;
    usleep(tm);
}

void user_updateWorkData(int gi, int index, struct WorkData *top, struct WorkData *current) {
    //check current ... set parent to correct
    #ifndef DISABLE_CHECK
    int i, k, div;
	#endif

	#ifdef API_TRACE
	printf("\x1b[22;30;47m[app_synthetic trace] user_updateWork(%d, %d, %p, %p)\x1b[0m\n", gi, index, top, current);
	#endif

    #ifndef DISABLE_CHECK
    div = (int)pow(2, gi);

    assert(current->count==0 || current->chunks[0].size==oss/((int)pow(2,gi)));

    for(k=0; k<current->count; k++) {
		printData("user_updateWork", current->chunks[k].data, current->chunks[k].size);
        for(i=0; i<current->chunks[k].size; i++) {
            char ex = (char)(10+i+k+index*(oss/div))%255;
            if( ((char *)current->chunks[k].data)[i] != ex ) {
                printf("\x1b[1;5;37;41mERROR(user_updateWork): Invalid response checking of wn %d, gi %d (pos %d != %d)\x1b[0m\n", index, gi, i, ex);
                exit(0);
            }
        }
    }
	
	assert(current->count==top->count);

    for(k=0; k<current->count; k++) {
		if(current->chunks[k].refs==-1) continue; // recv in place
		else {
			printf("\x1b[1;5;37;41mERROR(user_updateWork): not virtual data segments in wn %d, gi %d\x1b[0m\n", index, gi);
		}
    }
    #endif
}

void user_readWorkData(int gi, int index, struct WorkData *work) {
    #ifndef DISABLE_CHECK
    int i, k, div;
	#endif

	#ifdef API_TRACE
	printf("\x1b[22;30;47m[app_synthetic trace] user_readWorkData(%d, %d, %p)\x1b[0m\n", gi, index, work);
	#endif

    #ifndef DISABLE_CHECK
    div = (int)pow(2, gi);
    for(k=0; k<work->count; k++) {        
        for(i=0; i<work->chunks[k].size; i++) {
            ((char *)work->chunks[k].data)[i] = (char)(1+i+k+index*(iss/div))%255;
        }
        printData("user_readWorkData", work->chunks[k].data, work->chunks[k].size);
    }
    #endif
}

void user_writeWorkData(int gi, int index, struct WorkData *work) {
    // do some data check to verify comunication.
    #ifndef DISABLE_CHECK
    int i, k, div;
    #endif

	#ifdef API_TRACE
	printf("\x1b[22;30;47m[app_synthetic trace] user_writeWorkData(%d, %d, %p)\x1b[0m\n", gi, index, work);
	#endif

    #ifndef DISABLE_CHECK
    div = (int)pow(2, gi);
    for(k=0; k<work->count; k++) {
		printData("user_writeWorkData", work->chunks[k].data, work->chunks[k].size);
        for(i=0; i<work->chunks[k].size; i++) {
            char ex = (char)(10+i+k+index*(oss/div))%255;
            if( ((char *)work->chunks[k].data)[i] != ex ) {
                printf("\x1b[1;5;37;41mERROR(user_writeWorkData): Invalid response checking of wn %d, gi %d\x1b[0m\n", index, gi);
                exit(0);
            }
        }
    }
    #endif
}

void user_freeWorkData(struct WorkData *work) {
    int i;

	#ifdef API_TRACE
    printf("\x1b[22;30;47m[app_synthetic trace] user_freeWorkData(%p)\x1b[0m\n", work);
	#endif

	for(i=0;i<work->count;i++) {
		if(work->chunks[i].refs!=-1) {
            free((void*)work->chunks[i].data);
        }        
	}
    free(work->chunks);
    free(work);
}

void user_finalize() {}
void user_iteration_start(int i) {}
void user_iteration_end(int i) {}

