#include "mpi.h"
#include <stdio.h>

int main( int argc, char **argv ) {
	MPI_Init(&argc,&argv);

	int rank;
	int size;
	MPI_Comm_rank(MPI_COMM_WORLD, &rank);
	MPI_Comm_size(MPI_COMM_WORLD, &size);
	MPI_Status status;

	printf("rank: %d, worldsize:%d\n",rank, size);

	char portname[MPI_MAX_PORT_NAME];
	MPI_Open_port(MPI_INFO_NULL, portname);
	printf("rank=%d, portname is %s\n",rank,portname);
	
	MPI_Comm client_comm, acc_comm;
	MPI_Comm_accept(portname, MPI_INFO_NULL, 0, MPI_COMM_WORLD, &client_comm);
	MPI_Intercomm_merge(client_comm, 1, &acc_comm);

	int accRank;
	int accWorldSize;
	MPI_Comm_rank(acc_comm, &accRank);
	MPI_Comm_size(acc_comm, &accWorldSize);
	printf("rank: %d, worldsize:%d, acc rank: %d, acc world size: %d, \n",rank, size, accRank, accWorldSize); fflush(stdout);

	printf("made the connection\n");
	MPI_Comm temp_comm, acc_comm2;
	char portt[MPI_MAX_PORT_NAME];
	MPI_Recv( portt, MPI_MAX_PORT_NAME, MPI_CHAR, 0, 99, acc_comm, &status );
	printf("port to connect is %s,\n",portt); fflush(stdout);
	MPI_Comm_connect(portt, MPI_INFO_NULL, 0, acc_comm, &temp_comm);
	MPI_Intercomm_merge(temp_comm, 0, &acc_comm2);
	printf("connected to the other accelerator\n");
	MPI_Comm_rank(acc_comm2, &accRank);
	MPI_Comm_size(acc_comm2, &accWorldSize);
	printf("rank: %d, worldsize:%d, acc rank: %d, acc world size: %d, \n",rank, size, accRank, accWorldSize);

	MPI_Finalize();
	return 0;
}
