module forC_mod
  use iso_c_binding

  interface
     function set_device(procId) result(res) &
          & bind(c,name='setDeviceCUDA')
       use iso_c_binding
       integer(c_int),value :: procId
       integer(c_int) :: res
     end function set_device
  end interface
  
  interface
     function alloc_remote_buf(cptr,dim) result(res) &
          & bind(c,name='allocRemoteBuffer')
       use iso_c_binding
       type(c_ptr) :: cptr
       integer(c_int),value :: dim
       integer(c_int) :: res
     end function alloc_remote_buf
  end interface

  interface
     function free_remote_buf(cptr) result(res) &
          & bind(c,name='freeRemoteBuffer')
       use iso_c_binding
       type(c_ptr),value :: cptr
       integer(c_int) :: res
     end function free_remote_buf
  end interface

  interface
     function write_remote_buf(remote_buf,host_buf,dim) result(res) &
          & bind(c,name='writeRemoteBuffer')
       use iso_c_binding
       type(c_ptr),value :: remote_buf, host_buf
       integer(c_int),value :: dim
       integer(c_int) :: res
     end function write_remote_buf
  end interface

  interface
     function read_remote_buf(host_buf,remote_buf,dim) result(res) &
          & bind(c,name='readRemoteBuffer')
       use iso_c_binding
       type(c_ptr),value :: remote_buf, host_buf
       integer(c_int),value :: dim
       integer(c_int) :: res
     end function read_remote_buf
  end interface

  interface
   function print_double_buf(remote_buf,dim) result(res) &
          & bind(c,name='printDoubleBuffer')
       use iso_c_binding
       type(c_ptr),value :: remote_buf
       integer(c_int),value :: dim
       integer(c_int) :: res
     end function print_double_buf
  end interface
  
  interface 
     function receive(v,recvtype,procSender,tag,communicator,handle) &
          & result(res) bind(c,name='receiveRoutine')
       use iso_c_binding   
       !real(c_double)  :: v(*)
       type(c_ptr), value	:: v
       integer(c_int),value :: recvtype
       integer(c_int),value :: communicator
       integer(c_int),value :: procSender
       integer(c_int),value :: tag
       integer(c_int) :: handle
       integer(c_int)  :: res
     end function receive
  end interface
  
  interface 
     function send(v,sendtype,procToSend,tag,communicator) &
          & result(res) bind(c,name='sendRoutine')
       use iso_c_binding   
       !real(c_double)  :: v(*)
       type(c_ptr), value   :: v
       integer(c_int),value :: sendtype
       integer(c_int),value :: communicator
       integer(c_int),value :: procToSend
       integer(c_int),value :: tag
       integer(c_int)  :: res
     end function send
  end interface
  
end module forC_mod
