#include <stdio.h>
#include <mpi.h>

int receiveRoutine(void * y, int recvtype, int procSender,int tag, int comm, int *handle){
  
  double *y_gpu;
  MPI_Status stat;
  allocRemoteBuffer(&y_gpu,sizeof(double)*100);
  writeRemoteBuffer(y_gpu,y,sizeof(double)*100);
  MPI_Comm co = MPI_Comm_f2c(comm);
  MPI_Datatype dt = MPI_Type_f2c(recvtype);
  MPI_Request req;// = MPI_Request_f2c(*handle);
  MPI_Irecv(y_gpu, 1, dt, procSender,tag, co, &req);
  MPI_Wait(&req, &stat);
  *handle = MPI_Request_c2f(req);
  readRemoteBuffer(y, y_gpu, sizeof(double)*100);
  //printDoubleBuffer(y_gpu, 100);
  freeRemoteBuffer(y_gpu);
  return 0;
	
}

int sendRoutine(void * y, int sendtype, int procToSend,int tag, int comm){

  double *y_gpu;

  allocRemoteBuffer(&y_gpu,sizeof(double)*100);
  writeRemoteBuffer(y_gpu,y,sizeof(double)*100);
  
  MPI_Comm co = MPI_Comm_f2c(comm);
  MPI_Datatype dt = MPI_Type_f2c(sendtype);
  MPI_Send(y_gpu, 1, dt, procToSend,tag,co);

  freeRemoteBuffer(y_gpu);

  return 0;
}

