/* MPI2.2:*/

#include <stdio.h>
#include "mpi.h"

void CreateComm_dist_adj(MPI_Comm old_comm, MPI_Comm* comm, int mode, int useweight);
void CreateComm_distgraph(MPI_Comm old_comm, MPI_Comm* comm, int mode, int useweight);
void localDistGraphNeighbors(int src[], int src_w[], int dst[], int dst_w[]);
int validateNeighbors(int nProcs, int array1[], int array1_w[], int nLocalProcs, int array2[], int array2_w[], int useweight);

#define TOPO_TEST_COMM_CREATE   0
#define TOPO_TEST_COMM_DUP      1
#define TOPO_TEST_WEIGHT_ON     0
#define TOPO_TEST_WEIGHT_OFF    1

#define DIST_ARRAY_SIZE(ary)    (sizeof(ary)/sizeof(int))
#define DIST_TERMINATE_VALUE    (-1)

#define ERROR_HANDLE  \
               { printf("[%d] ERROR! in %s(%d)\n", rank, __func__, __LINE__); \
                 nError++; }
/*#define ERROR_HANDLE(func, line)  { nError++; }*/

static int rank, nprocs;

int main(int argc, char *argv[])
{
    int i;
    MPI_Comm comm[7];
    
    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

    /* Test */
    CreateComm_dist_adj(MPI_COMM_WORLD,  &comm[0], TOPO_TEST_COMM_CREATE, TOPO_TEST_WEIGHT_ON);
    CreateComm_dist_adj(comm[0],         &comm[1], TOPO_TEST_COMM_DUP,    TOPO_TEST_WEIGHT_ON);

    CreateComm_distgraph(MPI_COMM_WORLD, &comm[2], TOPO_TEST_COMM_CREATE, TOPO_TEST_WEIGHT_OFF);
    CreateComm_distgraph(comm[2],        &comm[3], TOPO_TEST_COMM_DUP,    TOPO_TEST_WEIGHT_OFF);
    
    CreateComm_dist_adj(MPI_COMM_WORLD,  &comm[4], TOPO_TEST_COMM_CREATE, TOPO_TEST_WEIGHT_ON);
    CreateComm_distgraph(comm[4],        &comm[5], TOPO_TEST_COMM_CREATE, TOPO_TEST_WEIGHT_ON);
    CreateComm_distgraph(comm[5],        &comm[6], TOPO_TEST_COMM_CREATE, TOPO_TEST_WEIGHT_ON);

    /* free comunicator  */
    for (i=0;i<(sizeof(comm)/sizeof(MPI_Comm));i++) {
        MPI_Comm_free(&comm[i]);
    }
    
    MPI_Barrier(MPI_COMM_WORLD);
    if (0==rank) printf("pass!!\n");
    
    MPI_Finalize();
    
    return 0;
}


/* for Dist_graph_create_adjacent */
void CreateComm_dist_adj(MPI_Comm old_comm, MPI_Comm* comm, int mode, int useweight)
{
    int rc, i;
    int nError = 0;

    int src[2];
    int dst[2];
    int src_w[2];
    int dst_w[2];
    int indeg[2];
    int outdeg[2];

    /* for check */
    int indegree, outdegree, weighted;
    int source_r[3];
    int source_w[3];
    int destination_r[3];
    int destination_w[3];

    /* create neighbors data */
    src[0]=(rank>0        ? rank-1 : nprocs-1);
    src[1]=(rank<nprocs-1 ? rank+1 : 0);
    src_w[0]=rank;
    src_w[1]=rank+1;

    dst[0]=(rank<nprocs-1 ? rank+1 : 0);
    dst[1]=(rank>0        ? rank-1 : nprocs-1);
    dst_w[0]=(rank)*10;
    dst_w[1]=(rank+1)*10;

    /* create dist-graph */
    if (TOPO_TEST_COMM_CREATE == mode) {
        if (TOPO_TEST_WEIGHT_ON == useweight) {
            rc = MPI_Dist_graph_create_adjacent(
                                       old_comm, 
                                       DIST_ARRAY_SIZE(src),
                                       src, 
                                       src_w, 
                                       DIST_ARRAY_SIZE(dst),
                                       dst, 
                                       dst_w, 
                                       MPI_INFO_NULL, 
                                       0, /* reoder */
                                       comm);
        } 
        else {
            rc = MPI_Dist_graph_create_adjacent(
                                       old_comm, 
                                       DIST_ARRAY_SIZE(src),
                                       src, 
                                       MPI_UNWEIGHTED, 
                                       DIST_ARRAY_SIZE(dst),
                                       dst, 
                                       MPI_UNWEIGHTED, 
                                       MPI_INFO_NULL, 
                                       0,  /* reoder */
                                       comm);
        }
    } 
    else {
        /* Duplicate comm */ /* MPICH not support? */
        rc = MPI_Comm_dup(old_comm, comm);
    }
    
    if (MPI_SUCCESS != rc) {
        printf("[%d] ERROR in %s(%d) rc=%d mode=%d useweught=%d\n", rank, __func__, __LINE__, rc, mode, useweight);
        MPI_Abort(old_comm, -1);
    }

    /* get neighbors count */
    rc = MPI_Dist_graph_neighbors_count(*comm, 
                                   &indegree, &outdegree, &weighted);
    if (MPI_SUCCESS != rc) ERROR_HANDLE
    if (DIST_ARRAY_SIZE(src) != indegree)  ERROR_HANDLE
    if (DIST_ARRAY_SIZE(dst) != outdegree) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_OFF == useweight) {
        if (weighted != 0) ERROR_HANDLE;
    } 
    else {
        if (weighted != 1) ERROR_HANDLE;
    }
    /* get neighbors */
    source_r[0]=source_r[1]=source_r[2]=DIST_TERMINATE_VALUE;
    source_w[0]=source_w[1]=source_w[2]=DIST_TERMINATE_VALUE;
    destination_r[0]=destination_r[1]=destination_r[2]=DIST_TERMINATE_VALUE;
    destination_w[0]=destination_w[1]=destination_w[2]=DIST_TERMINATE_VALUE;
    rc = MPI_Dist_graph_neighbors(*comm, 
                             indegree, source_r, source_w,
                             outdegree, destination_r, destination_w);
    if (MPI_SUCCESS != rc) ERROR_HANDLE
#if 0
    printf("[%d] src={%2d, %2d, %2d} dest={%2d, %2d, %2d}\n", 
                    rank, 
                    source_r[0], source_r[1], source_r[2],
                    destination_r[0], destination_r[1], destination_r[2]);
    printf("[%d] src_w={%2d, %2d, %2d} dest_w={%2d, %2d, %2d}\n", 
                    rank, 
                    source_w[0], source_w[1], source_w[2],
                    destination_w[0], destination_w[1], destination_w[2]);
#endif
    /* SOURCE CHECK */
    for (i=0;i<DIST_ARRAY_SIZE(src);i++) {
        if (src[i] != source_r[i])  ERROR_HANDLE;
    }
    if (source_r[DIST_ARRAY_SIZE(src)] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_ON==useweight) {
        for (i=0;i<DIST_ARRAY_SIZE(src_w);i++){
            if (src_w[i] != source_w[i])    ERROR_HANDLE
        }
        if (source_w[DIST_ARRAY_SIZE(src_w)] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    }

    /* DISTINATION CHECK */
    for (i=0;i<DIST_ARRAY_SIZE(dst);i++) {
        if (dst[i] != destination_r[i]) ERROR_HANDLE
    }
    if (destination_r[DIST_ARRAY_SIZE(dst)] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_ON==useweight) {
        for (i=0;i<DIST_ARRAY_SIZE(dst_w);i++) {
            if (dst_w[i] != destination_w[i])   ERROR_HANDLE
        }
        if (destination_w[DIST_ARRAY_SIZE(dst_w)] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    }

    /* summary */
    int reduce[] = {rank, nError};
    rc = MPI_Allreduce(MPI_IN_PLACE, reduce, 2, MPI_INT, MPI_MAX, *comm);
    if (nprocs-1 != reduce[0] || 0 != reduce[1]) {
        printf("[%d] ERROR! in %s(%d) mode=%d useweught=%d error=%d\n", 
                            rank, __func__, __LINE__, mode, useweight, nError);
        MPI_Abort(*comm, -1);
    }
}

/* for MPI_Dist_graph_create */
void CreateComm_distgraph(MPI_Comm old_comm, MPI_Comm* comm, int mode, int useweight)
{
    int rc, rc2, i;
    int nError = 0;
    int dmy_rank;

    int src[2];
    int dst[2];
    int src_w[2];
    int degress[2];
    int n;

    int chk_src[2];
    int chk_dst[2];
    int chk_src_w[2];

    /* for query function */
    int indegree, outdegree, weighted;
    int source_r[3];
    int source_w[3];
    int destination_r[3];
    int destination_w[3];

    /* for check (local query) */
    int chk_source_r[3];
    int chk_source_w[3];
    int chk_destination_r[3];
    int chk_destination_w[3];

/*
  example: when procs is 3

    102     100     101     102         weight[1]
    ----->  ----->  ----->  ----->
  (R2)    R0      R1      R2     (R0)   rank
    <-----  <-----  <-----  <-----
        10      11      12      10      weight[0]

*/
    dmy_rank = (rank<nprocs-1 ? rank+1 : 0);

    n=1;
    src[0]=dmy_rank;
    degress[0]=2;
    dst[0]=(dmy_rank>0        ? dmy_rank-1 : nprocs-1);
    dst[1]=(dmy_rank<nprocs-1 ? dmy_rank+1 : 0);
    src_w[0]=dmy_rank+10;
    src_w[1]=dmy_rank+100;
    
    /* create dist-graph */
    if (TOPO_TEST_COMM_CREATE == mode) {
        if (TOPO_TEST_WEIGHT_ON == useweight) {
            rc = MPI_Dist_graph_create(old_comm, 
                                       n, 
                                       src, 
                                       degress, 
                                       dst, 
                                       src_w, 
                                       MPI_INFO_NULL, 
                                       0,  /* reoder */
                                       comm);
        } 
        else {
            rc = MPI_Dist_graph_create(old_comm, 
                                       n,
                                       src, 
                                       degress, 
                                       dst, 
                                       MPI_UNWEIGHTED, 
                                       MPI_INFO_NULL, 
                                       0,  /* reoder */
                                       comm);
        }
    } 
    else {
        /* Duplicate comm */ /* MPICH not support? */
        rc = MPI_Comm_dup(old_comm, comm);
    }
    if (MPI_SUCCESS != rc) ERROR_HANDLE

    /* get neighbors count */
    rc = MPI_Dist_graph_neighbors_count(*comm, 
                                   &indegree, &outdegree, &weighted);
    if (MPI_SUCCESS != rc) ERROR_HANDLE
    if (DIST_ARRAY_SIZE(src) != indegree) ERROR_HANDLE
    if (DIST_ARRAY_SIZE(dst) != outdegree) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_OFF == useweight) {
        if (weighted != 0) ERROR_HANDLE
    } 
    else {
        if (weighted != 1) ERROR_HANDLE
    }
    /*------------------------------------------------------------------*/
    /* Test 1 */
    source_r[0]=source_r[1]=source_r[2]=DIST_TERMINATE_VALUE;
    source_w[0]=source_w[1]=source_w[2]=DIST_TERMINATE_VALUE;
    destination_r[0]=destination_r[1]=destination_r[2]=DIST_TERMINATE_VALUE;
    destination_w[0]=destination_w[1]=destination_w[2]=DIST_TERMINATE_VALUE;
    
    rc = MPI_Dist_graph_neighbors(*comm, 
                             indegree, source_r, source_w,
                             outdegree, destination_r, destination_w);
    if (MPI_SUCCESS != rc) ERROR_HANDLE

#if 0
    printf("[%d] src  ={%2d, %2d, %2d} dest  ={%2d, %2d, %2d}\n", 
                    rank, 
                    source_r[0], source_r[1], source_r[2],
                    destination_r[0], destination_r[1], destination_r[2]);
    printf("[%d] src_w={%2d, %2d, %2d} dest_w={%2d, %2d, %2d}\n", 
                    rank, 
                    source_w[0], source_w[1], source_w[2],
                    destination_w[0], destination_w[1], destination_w[2]);
#endif
    /* get neighbors (local query) */
    localDistGraphNeighbors(chk_source_r, chk_source_w, chk_destination_r, chk_destination_w);
#if 0
    printf("[%d] check_src  ={%2d, %2d, %2d} dest  ={%2d, %2d, %2d}\n", 
                    rank, 
                    chk_source_r[0], chk_source_r[1], chk_source_r[2],
                    chk_destination_r[0], chk_destination_r[1], chk_destination_r[2]);
    printf("[%d] check_src_w={%2d, %2d, %2d} dest_w={%2d, %2d, %2d}\n", 
                    rank, 
                    chk_source_w[0], chk_source_w[1], chk_source_w[2],
                    chk_destination_w[0], chk_destination_w[1], chk_destination_w[2]);
#endif
    /* SOURCE CHECK */
    rc2 = validateNeighbors(indegree, source_r, source_w, 
                            indegree, chk_source_r, chk_source_w, useweight);
    if (0 != rc2) ERROR_HANDLE
    if (source_r[indegree] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_ON == useweight) {
        if (source_w[indegree] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    }

    /* DESTINATION CHECK */
    rc2 = validateNeighbors(outdegree, destination_r, destination_w, 
                            outdegree, chk_destination_r, chk_destination_w, useweight);
    if (0 != rc2) ERROR_HANDLE
    if (destination_r[outdegree] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_ON == useweight) {
        if (destination_w[outdegree] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    }

    /*------------------------------------------------------------------*/
    /* Test 2 */
    /* less than actual degree size */
    source_r[0]=source_r[1]=source_r[2]=DIST_TERMINATE_VALUE;
    source_w[0]=source_w[1]=source_w[2]=DIST_TERMINATE_VALUE;
    destination_r[0]=destination_r[1]=destination_r[2]=DIST_TERMINATE_VALUE;
    destination_w[0]=destination_w[1]=destination_w[2]=DIST_TERMINATE_VALUE;
    
    rc = MPI_Dist_graph_neighbors(*comm, 
                             indegree-1, source_r, source_w,
                             outdegree-1, destination_r, destination_w);
    if (MPI_SUCCESS != rc) ERROR_HANDLE
    
    /* SOURCE CHECK */
    rc2 = validateNeighbors(indegree-1, source_r, source_w, 
                            indegree,   chk_source_r, chk_source_w, useweight);
    if (0 != rc2) ERROR_HANDLE
    if (source_r[indegree-1] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_ON == useweight) {
        if (source_w[indegree-1] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    }

    /* DESTINATION CHECK */
    rc2 = validateNeighbors(outdegree-1, destination_r, destination_w, 
                            outdegree,   chk_destination_r, chk_destination_w, useweight);
    if (0 != rc2) ERROR_HANDLE
    if (destination_r[outdegree-1] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    if (TOPO_TEST_WEIGHT_ON == useweight) {
        if (destination_w[outdegree-1] != DIST_TERMINATE_VALUE) ERROR_HANDLE
    }

#if 0
    /*------------------------------------------------------------------*/
    /* Test 3 */
    /* more than actual degree size */ /* MPI_ERR_ARG occurs  */
    source_r[0]=source_r[1]=source_r[2]=DIST_TERMINATE_VALUE;
    source_w[0]=source_w[1]=source_w[2]=DIST_TERMINATE_VALUE;
    destination_r[0]=destination_r[1]=destination_r[2]=DIST_TERMINATE_VALUE;
    destination_w[0]=destination_w[1]=destination_w[2]=DIST_TERMINATE_VALUE;
    
    rc = MPI_Dist_graph_neighbors(*comm, 
                             indegree+1, source_r, source_w,
                             outdegree+1, destination_r, destination_w);
    if (MPI_SUCCESS == rc) ERROR_HANDLE
#endif

    /*------------------------------------------------------------------*/
    /* summary */
    int reduce[] = {rank, nError};
    rc = MPI_Allreduce(MPI_IN_PLACE, reduce, 2, MPI_INT, MPI_MAX, *comm);
    if (nprocs-1 != reduce[0] || 0 != reduce[1]) {
        printf("[%d] ERROR! in %s(%d) mode=%d useweught=%d error=%d\n", 
                            rank, __func__, __LINE__, mode, useweight, nError);
        MPI_Abort(*comm, -1);
    }
}

/* local neighbors query function */
void localDistGraphNeighbors(int src[], int src_w[], int dst[], int dst_w[])
{
    dst[0]=(rank<nprocs-1    ? rank+1 : 0);
    dst[1]=(rank>0           ? rank-1 : nprocs-1);
    dst_w[0]=rank+100;
    dst_w[1]=rank+10;
    
    src[0]=(rank<nprocs-1    ? rank+1 : 0);
    src[1]=(rank>0           ? rank-1 : nprocs-1);
    src_w[0]=src[0]+10;
    src_w[1]=src[1]+100;
}

/* check neighbors */
/*   array1: result value of the MPI query function  */
/*   array2: result value of local query function    */
int validateNeighbors(int nProcs, int array1[], int array1_w[], int nLocalProcs, int array2[], int array2_w[], int useweight)
{
    int i, j, nError = 0;
    for (i=0;i<nProcs;i++) { /* MPI result loop */
        for (j=0;j<nLocalProcs;j++) { /* Local result loop */
            if (TOPO_TEST_WEIGHT_ON==useweight) {
                if (array1[i]==array2[j] && array1_w[i]==array2_w[j]) break;
            } 
            else {
                if (array1[i]==array2[j]) break;
            }
        }
        if (j==nLocalProcs) nError++;   /* not found neighbor */
    }
    return nError;
}

