#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <mpi.h>

#define MAX_TEST 14
#define MAX_TEST_DATA MAX_TEST+1


int Num_dest;
int Reorder;
int *Procs1[MAX_TEST_DATA];
int *Procs2[MAX_TEST_DATA];
int *Answer[MAX_TEST_DATA];
int *Degree[MAX_TEST_DATA];
int *Weight[MAX_TEST_DATA];

static bool diff_procs(int cnt, int rank,int *pa, int*pb, int num, bool print){
    bool rc=true;
#if 1
    char  ans[1024*1024],  rst[1024*1024];
    sprintf(ans,"answer={");
    sprintf(rst,"result={");
#endif
    while(num--){
#if 1
        sprintf(ans+strlen(ans)," %2d",*pa);
        sprintf(rst+strlen(rst)," %2d",*pb);
#endif
        if(*pa++ != *pb++)rc=false;
    }
#if 1
    sprintf(ans+strlen(ans),"}",*pa);
    sprintf(rst+strlen(rst),"}",*pb);
    if(print && !rc){
    printf("COMM:%2d [%2d] %s %s\n", cnt, rank, ans, rst);
        fflush(stdout);
    }
#endif
   return rc;
}

static bool correct_result(int cnt,
                           int root,
                           int indegree,
                           int outdegree,
                           int weighted,
                           int *srce,
                           int *dest,
                           int *srcew,
                           int *destw,
                           int rank){
    int i, m, *j, *k;
    switch(cnt){
    case 1:
        if(rank == root){
            if(indegree!=0 || outdegree!=Num_dest || weighted!=1 ||
               srce!=NULL || srcew!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Procs1[1], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        }else{
            if(indegree!=1 || outdegree!=0 || weighted!=0 ||
               *srce!=root || dest!=NULL || destw!=NULL)
                return false;

        }
        break;
        

    case 2:
        if(rank == root){
//            if(indegree!=0 || outdegree!=Num_dest || weighted!=0 ||
            if(indegree!=0 || outdegree!=Num_dest || weighted!=1 ||
               srce!=NULL || srcew!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Procs1[1], dest, outdegree,0))return false;
        }else{
            if(indegree!=1 || outdegree!=0 || weighted!=1 ||
               *srce!=root || dest!=NULL || destw!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;

        }
        break;

    case 3:
        if(rank == root){
            if(indegree!=Num_dest || outdegree!=0 || weighted!=1 ||
               dest!=NULL || destw!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Procs1[1], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
        }else{
            if(indegree!=0 || outdegree!=1 || weighted!=0 ||
               srce!=NULL || *dest!=root || srcew!=NULL)
                return false;
        }
        break;
    case 4:
        if(rank == root){
            if(indegree!=Num_dest || outdegree!=0 || weighted!=1 ||
               dest!=NULL || destw!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Procs1[1], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
        }else{
//            if(indegree!=0 || outdegree!=1 || weighted!=0 ||
            if(indegree!=0 || outdegree!=1 || weighted!=1 ||
               srce!=NULL || *dest!=root || srcew!=NULL)
                return false;
        }
        break;

    case 5:
        if(indegree!=Num_dest*(Num_dest+1) || outdegree!=Num_dest*(Num_dest+1) || weighted!=1)
            return false;
        if(!diff_procs(cnt, rank, Answer[5], srce, indegree,0))return false;
        if(!diff_procs(cnt, rank, Answer[5], dest, outdegree,0))return false;
        if(!diff_procs(cnt, rank, Weight[5], srcew, indegree,0))return false;
        if(!diff_procs(cnt, rank, Weight[6], destw, outdegree,0))return false;
        break;

    case 6:
        if(indegree!=Num_dest || outdegree!=Num_dest || weighted!=1)
            return false;
        if(!diff_procs(cnt, rank, Procs1[6], srce, indegree,0))return false;
        if(!diff_procs(cnt, rank, Procs1[6], dest, outdegree,0))return false;
        if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
        if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        break;

    case 7:
        if(rank == root){
            if(indegree!=Num_dest*(Num_dest+1) || outdegree!=0 || weighted!=1 ||
               dest!=NULL || destw!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Answer[5], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[7], srcew, indegree,0))return false;
        }else{
            if(indegree!=(Num_dest-1)*(Num_dest+1) || outdegree!=Num_dest*(Num_dest+1) || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Answer[7], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Answer[5], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[7], srcew, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[8], destw, outdegree,0))return false;
        }
        break;

    case 8:
        if(rank == root){
            if(indegree!=Num_dest || outdegree!=0 || weighted!=1 ||
               dest!=NULL || destw!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Procs1[8], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
        }else{
            if(indegree!=Num_dest-1 || outdegree!=Num_dest || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Procs2[8], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Procs1[8], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        }
        break;
    case 9:
        if(rank == root){
            if(outdegree!=Num_dest*(Num_dest+1) || indegree!=0 || weighted!=1 ||
               srce!=NULL || srcew!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Answer[5], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[10], destw, outdegree,0))return false;

        }else{
            if(outdegree!=(Num_dest-1)*(Num_dest+1) || indegree!=Num_dest*(Num_dest+1) || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Answer[5], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Answer[7], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[9], srcew, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[10], destw, outdegree,0))return false;
        }
        break;
    case 10:
        if(rank == root){
//            if(indegree!=0 || outdegree!=Num_dest || weighted!=0 ||
            if(indegree!=0 || outdegree!=Num_dest || weighted!=1 ||
               srce!=NULL || srcew!=NULL)
                return false;
            if(!diff_procs(cnt, rank, Procs1[8], dest, outdegree,0))return false;
            //if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,1))return false;
        }else{
            if(indegree!=Num_dest || outdegree!=Num_dest-1 || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Procs1[8], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Procs2[8], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        }
        break;
    case 11:
    case 12:
        {
            if(indegree!=1 || outdegree!=1 || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Procs1[12], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Procs2[12], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        }
        break;
    case 13:
        if(rank){
            if(indegree!=2 || outdegree!=1 || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Answer[13], srce, indegree,0)){
                int tmp = *Answer[13];
                *Answer[13] = *(Answer[13]+1);
                *(Answer[13]+1) = tmp;
                if(!diff_procs(cnt, rank, Answer[13], srce, indegree,0))
                    return false;
            }
            if(!diff_procs(cnt, rank, Procs2[14], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[13], srcew, indegree,0)){
                //printf("%d-%d = %d-%d\n",*Weight[13], *(Weight[13]+1), *srcew, *(srcew+1) );
                int tmp = *Weight[13];
                *Weight[13] = *(Weight[13]+1);
                *(Weight[13]+1) = tmp;
                //printf("%d-%d = %d-%d\n",*Weight[13], *(Weight[13]+1), *srcew, *(srcew+1) );
                if(!diff_procs(cnt, rank, Weight[13], srcew, indegree,0))
                    return false;
            }
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        }else{
            if(indegree!=0 || outdegree!=Num_dest || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Procs2[14], dest, outdegree,1))return false;
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,1))return false;
        }
        break;
    case 14:
        if(rank){
            if(indegree!=2 || outdegree!=1 || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Procs1[14], srce, indegree,0))return false;
            if(!diff_procs(cnt, rank, Procs2[14], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], srcew, indegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        }else{
            if(indegree!=0 || outdegree!=Num_dest || weighted!=1)
                return false;
            if(!diff_procs(cnt, rank, Procs2[14], dest, outdegree,0))return false;
            if(!diff_procs(cnt, rank, Weight[0], destw, outdegree,0))return false;
        }
        break;

    }
    return true;

}

static int print_result(MPI_Comm comm, int cnt, int root){

    int indegree, outdegree, weighted, *srce, *dest, *srcew, *destw, *pi, i, rank, status, rc;
    static char buf[1024*1024];
    bool correct=true;

    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    rc = MPI_Topo_test(comm, &status);
    if(rc!= MPI_SUCCESS){
        printf("#ERROR# MPI_Topo_test() rc:%d\n", rc);
        fflush(stdout);
        return rc;
    }
    if(MPI_DIST_GRAPH!=status){
        printf("#ERROR# MPI_Topo_test() status:%d\n", status);
        return -1;
    }
    rc = MPI_Dist_graph_neighbors_count(comm, &indegree, &outdegree, &weighted);
    if(rc!= MPI_SUCCESS){
        printf("#ERROR#  MPI_Dist_graph_neighbors_count() rc:%d\n", rc);
        fflush(stdout);
        return rc;
    }
    sprintf(buf,"COMM:%2d [%2d] indegree=%2d outdegree=%2d weight=%2d ",
            cnt, rank, indegree, outdegree, weighted);
    if(indegree>0){
        srce  = malloc(sizeof(int) * indegree);
        srcew = malloc(sizeof(int) * indegree);
    }else{
        srce  = NULL;
        srcew = NULL;
    }
    if(outdegree>0){
        dest  = malloc(sizeof(int) * outdegree);
        destw = malloc(sizeof(int) * outdegree);
    }else{
        dest  = NULL;
        destw = NULL;
    }


    rc = MPI_Dist_graph_neighbors(comm, indegree, srce, srcew, outdegree, dest, destw);
    if(rc!= MPI_SUCCESS){
        printf("#ERROR#  MPI_Dist_graph_neighbors() rc:%d\n", rc);
        fflush(stdout);
        return rc;
    }

    pi=srce;
    for (i=0;i<indegree;i++){
        if(i==0){
            sprintf(buf+strlen(buf),"source={%2d",*pi++);
        }else{
            sprintf(buf+strlen(buf),",%2d",*pi++);
        }
        if(i+1==indegree){
            sprintf(buf+strlen(buf),"} ");
        }

    }
    pi=dest;
    for (i=0;i<outdegree;i++){
        if(i==0){
            sprintf(buf+strlen(buf),"dest={%2d",*pi++);
        }else{
            sprintf(buf+strlen(buf),",%2d",*pi++);
        }
        if(i+1==outdegree){
            sprintf(buf+strlen(buf),"}");
        }

    }
    sprintf(buf+strlen(buf), "\n");


    if(!correct_result(cnt, root, indegree, outdegree, weighted, srce, dest, srcew, destw, rank )){
        printf("%s",buf);
        fflush(stdout);
        return -1;
    }
    return MPI_SUCCESS;
}



static void wrap_dist_graph_create(int cnt, int rank, int n, int *sources, int *degrees,
                                       int* destinations, int *weights, MPI_Comm *newcomm){
    int rc;

    rc = MPI_Dist_graph_create(MPI_COMM_WORLD,
                               n,
                               sources,
                               degrees,
                               destinations,
                               weights,
                               MPI_INFO_NULL,
                               Reorder,
                               newcomm);

    if (MPI_SUCCESS != rc){
        printf("#ERROR# %2d[%2d] MPI_Dist_graph_create()\n", cnt, rank);
        MPI_Abort(MPI_COMM_WORLD, -1);
    }
}

static void wrap_dist_graph_create_adjacent(int cnt, int rank, int indegree, int *sources, int *sourceweights,
                                            int outdegree, int *destinations, int *destweights, MPI_Comm *newcomm){
    int rc;

    rc = MPI_Dist_graph_create_adjacent(MPI_COMM_WORLD,
                                        indegree,
                                        sources,
                                        sourceweights,
                                        outdegree,
                                        destinations,
                                        destweights,
                                        MPI_INFO_NULL,
                                        Reorder,
                                        newcomm);
    if (MPI_SUCCESS != rc){
        printf("#ERROR# %2d[%d] MPI_Dist_graph_create_adjacent()\n", cnt, rank);
        MPI_Abort(MPI_COMM_WORLD, -1);
    }
}

static void const_graph(int root){
    int rank, num_procs;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &num_procs);
    int *j, *k, *l, i, m, n;
    for(i=0; i< MAX_TEST_DATA; i++){
        Procs1[i]=NULL;
        Procs2[i]=NULL;
        Degree[i]=NULL;
        Answer[i]=NULL;
        Weight[i]=NULL;
    }

    j = Weight[0] = malloc(num_procs*(num_procs-1)*sizeof(int));
    i=num_procs*(num_procs-1);
    while(i){
        *j++=i--;

    }

    Num_dest = num_procs -1;
    Procs1[1] =  malloc((num_procs-1)*sizeof(int));
    Degree[3] =  malloc((num_procs-1)*sizeof(int));
    Procs1[3] =  malloc((num_procs-1)*sizeof(int));
    j= Procs1[1];
    k= Degree[3];
    l= Procs1[3];
    for(i=0; i<num_procs; i++){
        if(i != root){
            *j++ = i;
            *k++ = 1;
            *l++ = root;
        }
    }
    //5
    Procs1[5] = malloc(num_procs*sizeof(int));
    Degree[5] = malloc(num_procs*sizeof(int) );
    Procs2[5] = malloc(num_procs*(num_procs-1)*sizeof(int));
    j= Procs1[5];
    k= Degree[5];
    l= Procs2[5];
    for(i=0; i<num_procs; i++){
        *j++ = i;
        *k++ = num_procs-1;
        for(m=0; m<num_procs; m++){
            if(m != i)
                *l++=m;
        }
    }

    j= Answer[5]=malloc(num_procs*(num_procs-1)*sizeof(int));
    for(i=0; i<num_procs; i++){
        for(m=0; m<num_procs; m++){
            if(m!=rank)
                *j++=m;
        }
    }
    j= Weight[5]=malloc(num_procs*(num_procs-1)*sizeof(int));
    for(n=0; n<num_procs; n++){
        k =Weight[0];
        for(i=0; i<num_procs; i++){

            for(m=0; m<num_procs; m++){
                if(m!=i){
                    if(m == rank)
                        *j++=*k;
                    k++;
                }
            }
        }
    }
    j= Weight[6]=malloc(num_procs*(num_procs-1)*sizeof(int));
    for(n=0; n<num_procs; n++){
        k =Weight[0];
        for(i=0; i<num_procs; i++){

            for(m=0; m<num_procs; m++){
                if(m!=i){
                    if(i == rank)
                        *j++=*k;
                    k++;
                }
            }
        }
    }


    //6
    Procs1[6] = malloc((num_procs-1)*sizeof(int));
    j= Procs1[6];
    for(i=0; i<num_procs; i++){
        if(i != rank){
            *j++ = i;
        }
    }
    //7
    Procs1[7] = malloc((num_procs-1)*sizeof(int));
    Degree[7] = malloc((num_procs-1)*sizeof(int) );
    Procs2[7] = malloc((num_procs-1)*(num_procs-1)*sizeof(int));
    j= Procs1[7];
    k= Degree[7];
    l= Procs2[7];
    for(i=0; i<num_procs; i++){
        if(i!=root){
            *j++ = i;
            *k++ = num_procs-1;
            for(m=0; m<num_procs; m++){
                if(m != i)
                    *l++=m;
            }
        }
    }
    j= Answer[7]=malloc((num_procs)*(num_procs-2)*sizeof(int));
    if (rank!=root){
        for(i=0; i<num_procs; i++){
            for(m=0; m<num_procs; m++){
                if(m != rank && m!=root)
                    *j++=m;
            }
        }
    }
    j= Weight[7]=malloc(num_procs*(num_procs-1)*sizeof(int));
    for(n=0; n<num_procs; n++){
        k =Weight[0];
        for(i=0; i<num_procs; i++){
            if(i!=root){
                for(m=0; m<num_procs; m++){
                    if(m!=i){
                        if(m == rank)
                            *j++=*k;
                        k++;
                    }
                }
            }
        }
    }
    j= Weight[8]=malloc(num_procs*(num_procs-1)*sizeof(int));
    for(n=0; n<num_procs; n++){
        k =Weight[0];
        for(i=0; i<num_procs; i++){
            if(i!=root){
                for(m=0; m<num_procs; m++){
                    if(m!=i){
                        if(i == rank)
                            *j++=*k;
                        k++;
                    }
                }
            }
        }
    }

    //8 10
     Procs1[8] = malloc((num_procs-1)*sizeof(int));
     Procs2[8] = malloc((num_procs-2)*sizeof(int)+4);
     j = Procs1[8];
     k = Procs2[8];
     for(i=0; i<num_procs; i++){
         if(i != rank){
             *j++ = i;
             if(i != root && rank!=root){
                 *k++=i;
             }
         }
     }

    //9
    Procs1[9] = malloc(num_procs*sizeof(int));
    Degree[9] = malloc(num_procs*sizeof(int) );
    Procs2[9] = malloc((num_procs-2)*(num_procs)*sizeof(int));
    j= Procs1[9];
    k= Degree[9];
    l= Procs2[9];
    for(i=0; i<num_procs; i++){
        *j++ = i;
        if(i==root){
            *k++ = num_procs-1;
        }else{
            *k++ = num_procs-2;
        }
        for(m=0; m<num_procs; m++){
            if(m != i && m!=root)
                *l++=m;
        }
    }
    j= Weight[9]=malloc(num_procs*(num_procs-1)*sizeof(int));
    for(n=0; n<num_procs; n++){
        k =Weight[0];
        for(i=0; i<num_procs; i++){
            for(m=0; m<num_procs; m++){
                if(m!=root){
                    if(m!=i){
                        if(m == rank)
                            *j++=*k;
                        k++;
                    }
                }
            }
        }
    }
    j= Weight[10]=malloc(num_procs*(num_procs-1)*sizeof(int));
    for(n=0; n<num_procs; n++){
        k =Weight[0];
        for(i=0; i<num_procs; i++){
            for(m=0; m<num_procs; m++){
                if(m!=root){
                    if(m!=i){
                        if(i == rank)
                            *j++=*k;
                        k++;
                    }
                }
            }
        }
    }

    //11
    Procs1[11] = malloc(sizeof(int));
    Degree[11] = malloc(sizeof(int));
    Procs2[11] = malloc(sizeof(int));
    //Weight[11] = malloc(sizeof(int));
    *Procs1[11] = rank>0 ? rank-1 : num_procs-1;
    *Degree[11] = 1;
    *Procs2[11] = rank;

    //12
    Procs1[12] = malloc(sizeof(int));
    Procs2[12] = malloc(sizeof(int));
    //Weight[12] = malloc(sizeof(int));
    *Procs1[12] = rank>0 ? rank-1 : num_procs-1;
    *Procs2[12] = rank+1<num_procs ? rank+1 : 0;

    //13
    Procs1[13] = malloc(sizeof(int));
    Degree[13] = malloc(sizeof(int));
    *Procs1[13] = rank>0 ? rank-1 : num_procs-1;
    if(*Procs1[13]){
        Procs2[13] = malloc(sizeof(int));
        *Degree[13] = 1;
        *Procs2[13] = rank>0 ? rank : 1;
    }else{
        Procs2[13] = malloc(sizeof(int) * (num_procs-1));
        *Degree[13] = num_procs-1;
        j= Procs2[13];
        for(i=1; i<num_procs; i++){
                *j++ = i;
        }
    }
    if(rank){
        Weight[13] = malloc(sizeof(int)*2);
        *Weight[13] = *Weight[0];
        *(Weight[13]+1) = *(Weight[0]+rank-1);
        Answer[13] = malloc(sizeof(int)*2);
        *Answer[13] = 0;
        *(Answer[13]+1) = rank>1 ? rank-1 : num_procs-1;
    }

    //14
    if(rank){
        Procs1[14] = malloc(sizeof(int)*2);
        Procs2[14] = malloc(sizeof(int));
        *Procs1[14] = 0;
        *(Procs1[14]+1) = rank>1 ? rank-1 : num_procs-1;
        *Procs2[14] = rank+1<num_procs ? rank+1 : 1;

    }else{
        Procs1[14] = NULL;
        Procs2[14] = malloc(sizeof(int)*(num_procs-1));
        j= Procs2[14];
        for(i=1; i<num_procs; i++){
                *j++ = i;
        }
    }



}

static void dest_graph(){
    int i;
    for(i=0; i< MAX_TEST_DATA; i++){
        if(Procs1[i]!=NULL)free(Procs1[i]);
        if(Procs2[i]!=NULL)free(Procs2[i]);
        if(Degree[i]!=NULL)free(Degree[i]);
        if(Answer[i]!=NULL)free(Answer[i]);
        if(Weight[i]!=NULL)free(Weight[i]);
    }
}


static void create_graph(int cnt, int root, MPI_Comm *newcomm){

    int rank, num_procs;
    int n, *sources, *degrees, *destinations, *weights=MPI_UNWEIGHTED;
    int indegree, *sourceweights=MPI_UNWEIGHTED, outdegree, *destweights=MPI_UNWEIGHTED;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &num_procs);

    switch(cnt){
    case 1: //root->all
        if(rank == root){
            n = 1;
            sources = &rank;
            degrees = &Num_dest,
            destinations = Procs1[1];
            weights = Weight[0];
        }else{
            n = 0;
            sources =      NULL;
            degrees =      NULL,
            destinations = NULL;
        }
        break;


    case 3: //all->root
        if(rank == root){
            n = Num_dest;
            sources = Procs1[1];
            degrees = Degree[3];
            destinations = Procs1[3];
            weights = Weight[0];
        }else{
            n = 0;
            sources =      NULL;
            degrees =      NULL,
            destinations = NULL;
        }
        break;

    case 2: //root->all
        if(rank == root){
            indegree = 0;
            sources = NULL;
            outdegree = Num_dest;
            destinations = Procs1[1];
            destweights = Weight[0];
        }else{
            indegree = 1;
            sources = &root;
            outdegree = 0;
            destinations = NULL;
            sourceweights= Weight[0];
        }
        break;
    case 4: //all->root
       if(rank == root){
            indegree = Num_dest;
            sources = Procs1[1];
            sourceweights= Weight[0];
            outdegree = 0;
            destinations = NULL;
        }else{
            indegree = 0;
            sources = NULL;
            outdegree = 1;
            destinations = &root;
            destweights = Weight[0];
        }
        break;

    case 5: //all<->all
        {
            n = num_procs;
            sources = Procs1[5];
            degrees = Degree[5];
            destinations = Procs2[5];
            weights = Weight[0];
            break;
        }
    case 6: //all<->all
        {
            indegree = Num_dest;
            sources = Procs1[6];
            sourceweights= Weight[0];
            outdegree = Num_dest;
            destinations = Procs1[6];
            destweights = Weight[0];
        }
        break;
    case 7: //all<->all - root->all
        {
            n = Num_dest;
            sources = Procs1[7];
            degrees = Degree[7];
            destinations = Procs2[7];
            weights = Weight[0];
        }
        break;
    case 9: //all<->all - all->root
        {
            n = num_procs;
            sources = Procs1[9];
            degrees = Degree[9];
            destinations = Procs2[9];
            weights = Weight[0];
            break;
        }
    case 8: //all<->all - root->all
        if(rank==root){
            indegree = Num_dest;
            sources = Procs1[8];
            sourceweights= Weight[0];
            outdegree = 0;
            destinations = NULL;
        }else{
            indegree = Num_dest-1;
            sources = Procs2[8];
            sourceweights= Weight[0];
            outdegree = Num_dest;
            destinations = Procs1[8];
            destweights = Weight[0];
        }

        break;
    case 10://all<->all - all->root
        if(rank==root){
            indegree = 0;
            sources = NULL;
            outdegree = Num_dest;
            destinations = Procs1[8];
            destweights = Weight[0];
        }else{
            indegree = Num_dest;
            sources = Procs1[8];
            sourceweights= Weight[0];
            outdegree = Num_dest-1;
            destinations = Procs2[8];
            destweights = Weight[0];
        }
        break;

    case 11: //ring
        {
            n = 1;
            sources = Procs1[11];
            degrees = Degree[11];
            destinations = Procs2[11];
            weights = Weight[0];
            break;
        }

    case 12: //ring
        {
            indegree = 1;
            sources = Procs1[12];
            sourceweights= Weight[0];
            outdegree = 1;
            destinations = Procs2[12];
            destweights = Weight[0];
            break;
        }

    case 13: //wheel
        {
            n = 1;
            sources = Procs1[13];
            degrees = Degree[13];
            destinations = Procs2[13];
            weights = Weight[0];
        }
        break;

    case 14: //wheel
        if(!rank){
            indegree = 0;
            outdegree = Num_dest;
        }else{
            indegree = 2;
            outdegree = 1;
        }
        sources = Procs1[14];
        sourceweights= Weight[0];
        destinations = Procs2[14];
        destweights = Weight[0];
        break;

    case 15: //2D torus
        {
        }
        break;

    case 16: //2D torus
        {
        }

        break;

    }


    //////////////////////////////////
    if(cnt%2){
        wrap_dist_graph_create(cnt,
                               rank,
                               n,
                               sources,
                               degrees,
                               destinations,
                               weights,
                               newcomm);
    }else{
        wrap_dist_graph_create_adjacent(cnt,
                                        rank,
                                        indegree,
                                        sources,
                                        sourceweights,
                                        outdegree,
                                        destinations,
                                        destweights,
                                        newcomm);
    }

}

#define MAX_SEND 100
static int p2p_test(MPI_Comm comm, int cnt , int root){
    int rank, num_procs, i, r, a;
    MPI_Comm_rank(comm, &rank);
    MPI_Comm_size(comm, &num_procs);

    if (root == rank) {
        for(i=0; i<MAX_SEND; i++){
            for(r=0; r<num_procs; r++){
                if(r != rank){
                    MPI_Send(&i, 1, MPI_INT, r, 1, comm);

                    MPI_Recv(&a, 1, MPI_INT, r, 1, comm, MPI_STATUS_IGNORE);
                    if(a != i){
                        printf("#ERROR# %2d[%2d]Send->Recv()%d=%d \n",cnt, rank, a, i);
                        return -1;
                    }
                }
            }
        }
    }else{
        for(i=0; i<MAX_SEND; i++){
            MPI_Recv(&a, 1, MPI_INT, root, 1, comm, MPI_STATUS_IGNORE);
            if(a != i){
                printf("#ERROR# %2d[%2d]Send->Recv()%d=%d \n",cnt, rank, a, i);
                return -1;
            }
            MPI_Send(&i, 1, MPI_INT, root, 1, comm);
        }
    }


    if (root == rank) {
        int *b[MAX_SEND], rr;
        int *a = malloc(sizeof(int)*MAX_SEND);
        MPI_Request *request = malloc(sizeof(MPI_Request) * MAX_SEND * (num_procs-1) *2);
        MPI_Request *req = request;

        for(i=0; i<MAX_SEND; i++){
            b[i] = malloc(sizeof(int) * (num_procs-1));
            for(r=0,rr=0; r<num_procs; r++){
                if(r != rank){
                    *(a+i)=i;
                    MPI_Irecv(b[i]+rr++, 1, MPI_INT, r, 1, comm, req++);
                    MPI_Isend(a+i,       1, MPI_INT, r, 1, comm, req++);
                 }
            }
        }
        MPI_Waitall(MAX_SEND * (num_procs-1) * 2, request, MPI_STATUS_IGNORE);

        for(i=0; i<MAX_SEND; i++){
            for(r=0, rr=0; r<num_procs; r++){
                if(r != rank){
                    if(*(b[i]+rr)!=i){
                        int ii, jj;
                        printf("#ERROR# %2d[%2d]Send->Recv root b[%d][%d]:%d=%d \n",cnt, rank, i, rr, *(b[i]+rr), i);
                        
                        for(jj=0;jj<num_procs-1;jj++ ){
                                printf("[%02d]", jj);
                            for(ii=0;ii<MAX_SEND;ii++){
                                printf("%d-", *(b[ii]+jj));

                            }
                            printf("\n");
                        }
                        
                        return -1;
                    }
                    rr++;
                }
            }
            free(b[i]);
        }
        free(a);
        free(request);


    }else{
        int *a = malloc(sizeof(int)*MAX_SEND);
        int *b = malloc(sizeof(int)*MAX_SEND);
        MPI_Request *request = malloc(sizeof(MPI_Request) * MAX_SEND *2);
        MPI_Request *req = request;
        for(i=0; i<MAX_SEND; i++){
            *(a+i)=i;
            MPI_Irecv(b+i, 1, MPI_INT, root, 1, comm, req++);
            MPI_Isend(a+i, 1, MPI_INT, root, 1, comm, req++);
        }
        MPI_Waitall(MAX_SEND * 2, request, MPI_STATUS_IGNORE);

        for(i=0; i<MAX_SEND; i++){
            if(*(b+i)!=i){
                printf("#ERROR# %2d[%2d]Send->Recv b[%d]:%d=%d \n",cnt, rank, i, *(b+i), i);
                return -1;
            }
        }
        free(a);
        free(b);
        free(request);

    }

    return MPI_SUCCESS;
}

static int coll_test(MPI_Comm comm, int cnt , int root){
    int rank, num_procs, i;
    MPI_Comm_rank(comm, &rank);
    MPI_Comm_size(comm, &num_procs);
    {
        double a=9.99;
        int ia;
        if(rank == root){
            a=6.25;
        }
        MPI_Bcast(&a, 1, MPI_DOUBLE, root, comm);
        ia = (int)(a*100.0);
        if(ia!=625){
            printf("#ERROR# %2d[%2d]Bcast()DOUBLE %lf(%lf) \n",cnt, rank, a, 6.25);
            return -1;
        }
    }
    {
        double a = (double)rank*0.1, b, c, d;

        int ib, ic, id, iba, ica, ida;
        double ba=0.0, ca=0.1*(num_procs-1), da=0.0;

        MPI_Allreduce(&a, &b,1,MPI_DOUBLE, MPI_SUM, comm);
        MPI_Allreduce(&a, &c,1,MPI_DOUBLE, MPI_MAX, comm);
        MPI_Allreduce(&a, &d,1,MPI_DOUBLE, MPI_MIN, comm);


        for(i=0; i<num_procs; i++){
            ba += 0.1 * i;
        }
        ib =  (int)(b*10.0);
        iba = (int)(ba*10.0);
        ic =  (int)(c*10.0);
        ica = (int)(ca*10.0);
        id =  (int)(d*10.0);
        ida = (int)(da*10.0);

        if(ib!=iba || ic!=ica || id!=ida){
            printf("#ERROR# %2d[%2d]Allreduce()DOUBLE SUM:%lf(%lf) MAX:%lf(%lf) MIN:%lf(%lf)\n",
                   cnt, rank, b, ba, c, ca, d, da);
            return -1;
        }
    }
    {
        unsigned long a = (unsigned long)rank, b, c, d;
        if(rank==root)a=(unsigned long)0xFFFFFFFFFFFFFFFF;
        
        MPI_Reduce(&a, &b,1,MPI_UNSIGNED_LONG, MPI_SUM, root, comm);
        MPI_Reduce(&a, &c,1,MPI_UNSIGNED_LONG, MPI_MAX, root, comm);
        MPI_Reduce(&a, &d,1,MPI_UNSIGNED_LONG, MPI_MIN, root, comm);

        if(rank == root){
            unsigned long ba, ca, da;
            ba = (unsigned long)0xFFFFFFFFFFFFFFFF;
            ca = (unsigned long)0xFFFFFFFFFFFFFFFF;
            da = (unsigned long)0xFFFFFFFFFFFFFFFF;
            for(i=0; i<num_procs; i++){
                if(i!=root){
                    ba += i;
                    da=(i<da)?i:da;
                }
            }
            if(b!=ba || c!=ca || d!=da){
                printf("#ERROR# %2d[%2d]Reduce()UNSIGNED_LONG SUM:%lu(%lu) MAX:%lu(%lu) MIN:%lu(%lu)\n",
                       cnt, rank, b, ba, c, ca, d, da);
                return -1;
            }
        }
    }

    {
        int a = rank, i;
        int *b = malloc(num_procs * sizeof(int));

        MPI_Allgather(&a, 1, MPI_INT, b, 1, MPI_INT, comm);

        for(i=0; i<num_procs; i++){

            if(b[i] != i){
                printf("#ERROR# %2d[%2d]Allgather() b[%d]: %d\n",
                       cnt, rank, i, b[i]);
                return -1;
            }

        }
        free(b);
    }
    {
        int a = rank, i;
        int *b = malloc(num_procs * sizeof(int));

        MPI_Gather(&a, 1, MPI_INT, b, 1, MPI_INT, root, comm);

        if(rank == root){
            for(i=0; i<num_procs; i++){

                if(b[i] != i){
                    printf("#ERROR# %2d[%2d]Gather() b[%d]: %d\n",
                       cnt, rank, i, b[i]);
                    return -1;
                }
            }
        }
        free(b);
    }

    {
        int b, i;
        int *a = malloc(num_procs * sizeof(int));

        if(rank == root){
            for(i=0; i<num_procs; i++){
                *(a+i) = i;
            }
        }
        MPI_Scatter(a, 1, MPI_INT, &b, 1, MPI_INT, root, comm);

        if(b != rank){
            printf("#ERROR# %2d[%2d]Scatter() %d: %d\n",
                   cnt, rank, i, b);
            return -1;
        }
    }

    MPI_Barrier(comm);
    return MPI_SUCCESS;

}

int main(int argc, char *argv[]){

    int rank, num_procs, rc, root;
    MPI_Comm newcomm;
    int cnt;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &num_procs);
    for (Reorder=0; Reorder<2; Reorder++){
        root = num_procs-1;
        while(true){
            const_graph(root);
            for(cnt=1; cnt <= MAX_TEST; cnt++){
                create_graph(cnt, root, &newcomm);
                if (MPI_SUCCESS != print_result(newcomm, cnt, root)){
                    MPI_Abort(MPI_COMM_WORLD, -1);
                }
                if (MPI_SUCCESS != p2p_test(newcomm, cnt, root)){
                    MPI_Abort(MPI_COMM_WORLD, -1);
                }
                if (MPI_SUCCESS != coll_test(newcomm, cnt, root)){
                    MPI_Abort(MPI_COMM_WORLD, -1);
                }
                MPI_Comm_free(&newcomm);
            }
            dest_graph();

            if(!root)break;
            root-=(num_procs/2);
            if(root<0)root=0;
        }
    }
    MPI_Finalize();
    if(!rank){
        printf("pass!!\n");
        fflush(stdout);
    }
    return 0;
}
