/* class simpleJNI_MPI */
/* Bibrak Qamar */
#include "simpleJNI_MPI.h"
#include "mpi.h"
#include <inttypes.h>
#include <stdlib.h>
#include <string.h>

/* JNI caching
 * JNI_OnLoad()
 */

jint JNI_OnLoad(JavaVM *vm, void *reserved) {

  JNIEnv *env;

  if (JNI_OK != (*vm)->GetEnv(vm, (void **) &env, JNI_VERSION_1_6)) {
    exit(1);
  }

  return JNI_VERSION_1_6;

}

/*
 * Class:     simpleJNI_MPI
 * Method:    nativeInit
 * Signature: ([Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_simpleJNI_1MPI_nativeInit
(JNIEnv *env, jobject thisObject, jobjectArray args) {

  //the logic of this function is almost same as of mpi-Java

  jclass string = (*env)->FindClass(env, "java/lang/String");
  int len = (*env)->GetArrayLength(env, args);
  char ** sargs = (char**) calloc(len+1, sizeof(char*));
  int errCode;

  jobject newArgs;

  int i;
  int flag;

  //parse the args array element wise and populate the sargs
  for (i=0; i<len; i++) {
    int slen;

    jstring jc = (jstring)(*env)->GetObjectArrayElement(env, args, i);
    slen = strlen((*env)->GetStringUTFChars(env, jc, 0)) + 1;
    sargs[i] = (char*) calloc(slen, sizeof(char));

    strcpy(sargs[i], (*env)->GetStringUTFChars(env, jc, 0));
  }

  errCode = MPI_Init(&len, &sargs);

}

/*
 * Class:     simpleJNI_MPI
 * Method:    nativeFinish
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_simpleJNI_1MPI_nativeFinish
(JNIEnv *env, jobject thisObject) {

  int errCode = MPI_Finalize();

  if (errCode != MPI_SUCCESS) {
    printf("Error in MPI_Finalize()\n");
    fflush(stdout);
  }

}

/*
 * Class:     simpleJNI_MPI
 * Method:    getCOMM_WORLD
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_simpleJNI_1MPI_getCOMM_1WORLD(JNIEnv *env,
    jobject thisObject) {

  return (jlong) MPI_COMM_WORLD;
}

/*
 * Class:     simpleJNI_MPI
 * Method:    rank
 * Signature: (J)I
 */
JNIEXPORT jint JNICALL Java_simpleJNI_1MPI_rank(JNIEnv *env, jobject thisObject,
    jlong comm) {

  MPI_Comm mpi_comm = (MPI_Comm) (intptr_t) comm;
  int rank;
  int errCode = MPI_Comm_rank(mpi_comm, &rank);

  if (errCode != MPI_SUCCESS) {
    printf("Error in MPI_Comm_rank()\n");
    fflush (stdout);
  }
  return rank;

}

/*
 * Class:     simpleJNI_MPI
 * Method:    size
 * Signature: (J)I
 */
JNIEXPORT jint JNICALL Java_simpleJNI_1MPI_size(JNIEnv *env, jobject thisObject,
    jlong comm) {

  MPI_Comm mpi_comm = (MPI_Comm) (intptr_t) comm;
  int size;
  int errCode = MPI_Comm_size(mpi_comm, &size);

  if (errCode != MPI_SUCCESS) {
    printf("Error in MPI_Comm_size()\n");
    fflush (stdout);
  }
  return size;

}

