/*
 * Simple Java program to call native MPI library 
 * Bibrak Qamar
 */

public class simpleJNI_MPI {

  /*
   * Static Block for loading the libsimpleJNI_MPI.so
   */
  static {
   // System.load("/home/bibrak/work/JNI_to_MPI/libsimpleJNI_MPI.so");
    System.loadLibrary("simpleJNI_MPI");
  }

  static public void main(String[] args) throws Exception {

    try {
      simpleJNI_MPI mpiCaller = new simpleJNI_MPI();

      mpiCaller.initMPI(args);

      long COMM_WORLD = mpiCaller.getCommWorld();
      System.out.println("Hi from " + mpiCaller.getRank(COMM_WORLD)
	  + " out of " + mpiCaller.getSize(COMM_WORLD));

      mpiCaller.finalizeMPI();
    }
    catch (Exception e) {

    }
  }

  public simpleJNI_MPI() {
  }

  public void initMPI(String[] args) throws Exception {

    nativeInit(args);
  }

  public void finalizeMPI() throws Exception {

    nativeFinish();
  }

  public long getCommWorld() throws Exception {

    return getCOMM_WORLD();
  }

  public long getRank(long handle) throws Exception {

    return rank(handle);
  }

  public long getSize(long handle) throws Exception {

    return size(handle);
  }

  // native functions
  private native void nativeInit(String[] args);

  private native void nativeFinish();

  private native long getCOMM_WORLD();

  private native int rank(long handle);

  private native int size(long handle);

}
