/* ompi/include/ompi_config.h.  Generated by configure.  */
/* -*- c -*-
 *
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2005 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart,
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 *
 * Function: - OS, CPU and compiler dependent configuration
 */

#ifndef OMPI_CONFIG_H_
#define OMPI_CONFIG_H_

#include "opal_config.h"


/***********************************************************************
 *
 * OMPI-specific Fortran code that should be in ompi_config.h, but not
 * in the other projects.
 *
 **********************************************************************/

/* MPI_Fint is the same as ompi_fortran_INTEGER_t */
#define MPI_Fint ompi_fortran_integer_t

/* MPI_Flogical is the same as the ompi_fortran_logical_t */
#define MPI_Flogical ompi_fortran_logical_t

#if OMPI_HAVE_FORTRAN_REAL && OMPI_HAVE_FORTRAN_COMPLEX
/* * C type for Fortran COMPLEX */
typedef struct {
  ompi_fortran_real_t real;
  ompi_fortran_real_t imag;
} ompi_fortran_complex_t;
#endif

#if OMPI_HAVE_FORTRAN_REAL4 && OMPI_HAVE_FORTRAN_COMPLEX8
/* * C type for Fortran COMPLEX*8 */
typedef struct {
  ompi_fortran_real4_t real;
  ompi_fortran_real4_t imag;
} ompi_fortran_complex8_t;
#endif

#if OMPI_HAVE_FORTRAN_REAL8 && OMPI_HAVE_FORTRAN_COMPLEX16
/* * C type for Fortran COMPLEX*16 */
typedef struct {
  ompi_fortran_real8_t real;
  ompi_fortran_real8_t imag;
} ompi_fortran_complex16_t;
#endif

#if OMPI_HAVE_FORTRAN_REAL16 && OMPI_HAVE_FORTRAN_COMPLEX32
/* * C type for Fortran COMPLEX*32 */
typedef struct {
  ompi_fortran_real16_t real;
  ompi_fortran_real16_t imag;
} ompi_fortran_complex32_t;
#endif

#if OMPI_HAVE_FORTRAN_DOUBLE_PRECISION
/* * C type for Fortran DOUBLE COMPLEX */
typedef struct {
  ompi_fortran_double_precision_t real;
  ompi_fortran_double_precision_t imag;
} ompi_fortran_double_complex_t;
#endif

#endif
