#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"

/* MPI_Dist_graph_create */

/* expected result
[0] indegree=3 outdegree=2 weight=1
[0] src  ={ 1,  4,  3, -1, -1} dest  ={ 2,  3, -1, -1, -1}
[0] src_w={11, 14, 13, -1, -1} dest_w={10, 10, -1, -1, -1}
[1] indegree=2 outdegree=2 weight=1
[1] src  ={ 4,  2, -1, -1, -1} dest  ={ 0,  4, -1, -1, -1}
[1] src_w={14, 12, -1, -1, -1} dest_w={11, 11, -1, -1, -1}
[2] indegree=1 outdegree=2 weight=1
[2] src  ={ 0, -1, -1, -1, -1} dest  ={ 1,  3, -1, -1, -1}
[2] src_w={10, -1, -1, -1, -1} dest_w={12, 12, -1, -1, -1}
[3] indegree=2 outdegree=2 weight=1
[3] src  ={ 0,  2, -1, -1, -1} dest  ={ 0,  4, -1, -1, -1}
[3] src_w={10, 12, -1, -1, -1} dest_w={13, 13, -1, -1, -1}
[4] indegree=2 outdegree=2 weight=1
[4] src  ={ 3,  1, -1, -1, -1} dest  ={ 0,  1, -1, -1, -1}
[4] src_w={13, 11, -1, -1, -1} dest_w={14, 14, -1, -1, -1}
*/

int main(int argc, char *argv[])
{
    int rank, nprocs;
    int rc;

    MPI_Comm newcomm;

    int n[] = {1,1,2,2,2};

    int src0[] = {2};
    int src1[] = {1};
    int src2[] = {0, 4};
    int src3[] = {4, 3};
    int src4[] = {2, 3};
    
    int deg0[] = {1};
    int deg1[] = {2};
    int deg2[] = {2, 1};
    int deg3[] = {1, 1};
    int deg4[] = {1, 1};
    
    int dest0[] = {1};
    int dest1[] = {0,4};
    int dest2[] = {2,3, 1};
    int dest3[] = {0,   0};
    int dest4[] = {3,   4};

    int wt0[]={12};
    int wt1[]={11,11};
    int wt2[]={10,10, 14};
    int wt3[]={14,    13};
    int wt4[]={12,    13};
    
    int* sources[] = {src0, src1, src2, src3, src4};
    int* degrees[] = {deg0, deg1, deg2, deg3, deg4};
    int* destinations[] = {dest0, dest1, dest2, dest3, dest4};
    int* weights[] = {wt0, wt1, wt2, wt3, wt4};

    int indegree, outdegree, weighted;
    int source_r[5] = {-1, -1, -1, -1, -1};
    int source_w[5] = {-1, -1, -1, -1, -1};
    int destination_r[5] = {-1, -1, -1, -1, -1};
    int destination_w[5] = {-1, -1, -1, -1, -1};
    
    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

    if (5 != nprocs)
    {
        printf("expect 5 procs\n");
        MPI_Abort(MPI_COMM_WORLD, -1);
    }

#if 0
    rc = MPI_Dist_graph_create(MPI_COMM_WORLD, 
                               n[rank], 
                               sources[rank], 
                               degrees[rank], 
                               destinations[rank], 
                               MPI_UNWEIGHTED, 
                               MPI_INFO_NULL, 
                               0, 
                               &newcomm);
#else
    rc = MPI_Dist_graph_create(MPI_COMM_WORLD, 
                               n[rank], 
                               sources[rank], 
                               degrees[rank], 
                               destinations[rank], 
                               weights[rank], 
                               MPI_INFO_NULL, 
                               0, 
                               &newcomm);
#endif
    if (MPI_SUCCESS != rc)
    {
        printf("[%d] MPI_Dist_graph_create() ERROR!!\n", rank);
        MPI_Abort(MPI_COMM_WORLD, -1);
    }

    MPI_Dist_graph_neighbors_count(newcomm, 
                                   &indegree, &outdegree, &weighted);
    printf("[%d] indegree=%d outdegree=%d weight=%d\n", rank, indegree, outdegree, weighted);

    MPI_Dist_graph_neighbors(newcomm, 
                             indegree, source_r, source_w,
                             outdegree, destination_r, destination_w);
    printf("[%d] src  ={%2d, %2d, %2d, %2d, %2d} dest  ={%2d, %2d, %2d, %2d, %2d}\n", 
                    rank, 
                    source_r[0], source_r[1], source_r[2], source_r[3], source_r[4], 
                    destination_r[0], destination_r[1], destination_r[2], destination_r[3], destination_r[4]);
    printf("[%d] src_w={%2d, %2d, %2d, %2d, %2d} dest_w={%2d, %2d, %2d, %2d, %2d}\n", 
                    rank, 
                    source_w[0], source_w[1], source_w[2],source_w[3],source_w[4],
                    destination_w[0], destination_w[1], destination_w[2],destination_w[3],destination_w[4]);

    MPI_Comm_free(&newcomm);
    MPI_Finalize();
    
    return 0;
}
