#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"

/* MPI_Dist_graph_create_adjacent */

/* expected result
[0] indegree=3 outdegree=2 weight=0
[0] src={ 1,  4,  3, -1, -1} dest={ 2,  3, -1, -1, -1}
[1] indegree=2 outdegree=2 weight=0
[1] src={ 4,  2, -1, -1, -1} dest={ 0,  4, -1, -1, -1}
[2] indegree=1 outdegree=2 weight=0
[2] src={ 0, -1, -1, -1, -1} dest={ 3,  1, -1, -1, -1}
[3] indegree=2 outdegree=2 weight=0
[3] src={ 2,  0, -1, -1, -1} dest={ 4,  0, -1, -1, -1}
[4] indegree=2 outdegree=2 weight=0
[4] src={ 3,  1, -1, -1, -1} dest={ 0,  1, -1, -1, -1}
*/

int main(int argc, char *argv[])
{
    int rank, nprocs;
    int rc;

    MPI_Comm newcomm;

    int src0[] = {1,3,4};
    int src1[] = {2,4};
    int src2[] = {0};
    int src3[] = {0,2};
    int src4[] = {1,3};
    
    int dest0[] = {2,3};
    int dest1[] = {0,4};
    int dest2[] = {1,3};
    int dest3[] = {0,4};
    int dest4[] = {0,1};

    int* sources[] = {src0, src1, src2, src3, src4};
    int* destinations[] = {dest0, dest1, dest2, dest3, dest4};
    int indeg[]  = {3,2,1,2,2};
    int outdeg[] = {2,2,2,2,2};


    int indegree, outdegree, weighted;
    int source_r[5] = {-1, -1, -1, -1, -1};
    int source_w[5] = {-1, -1, -1, -1, -1};
    int destination_r[5] = {-1, -1, -1, -1, -1};
    int destination_w[5] = {-1, -1, -1, -1, -1};
    

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

    if (5 != nprocs)
    {
        printf("expect 5 procs\n");
        MPI_Abort(MPI_COMM_WORLD, -1);
    }

    rc = MPI_Dist_graph_create_adjacent(
                               MPI_COMM_WORLD, 
                               indeg[rank], 
                               sources[rank], 
                               MPI_UNWEIGHTED, 
                               outdeg[rank], 
                               destinations[rank], 
                               MPI_UNWEIGHTED, 
                               MPI_INFO_NULL, 
                               0, 
                               &newcomm);
    if (MPI_SUCCESS != rc)
    {
        printf("[%d] MPI_Dist_graph_create_adjacent() ERROR!!\n", rank);
        MPI_Abort(MPI_COMM_WORLD, -1);
    }

    MPI_Dist_graph_neighbors_count(newcomm, 
                                   &indegree, &outdegree, &weighted);
    printf("[%d] indegree=%d outdegree=%d weight=%d\n", rank, indegree, outdegree, weighted);

    MPI_Dist_graph_neighbors(newcomm, 
                             indegree, source_r, source_w,
                             outdegree, destination_r, destination_w);
    printf("[%d] src={%2d, %2d, %2d, %2d, %2d} dest={%2d, %2d, %2d, %2d, %2d}\n", 
                    rank, 
                    source_r[0], source_r[1], source_r[2], source_r[3], source_r[4], 
                    destination_r[0], destination_r[1], destination_r[2], destination_r[3], destination_r[4]);

    MPI_Comm_free(&newcomm);

    MPI_Finalize();
    
    return 0;
}
