import QtQuick 2.0
import Sailfish.Silica 1.0

ApplicationWindow {
    Component {
        id: mainPage
        Page {
            SilicaListView {
                id: listView
                anchors {
                    top: parent.top
                    bottom: buttonRow.top
                    left: parent.left
                    right: parent.right
                }

                delegate: Component {
                    ListItem {
                        Row {
                            Label {
                                text: index
                            }
                            Label {
                                text: value
                            }
                        }
                        Component.onCompleted: {
                            console.debug("Created delegate: " + index)
                        }
                    }
                }
            }
            Row {
                id: buttonRow
                anchors {
                    bottom: parent.bottom
                    right: parent.right
                    left: parent.left
                }

                Button {
                    text: "populate"
                    onClicked: {

                        for (var i = 0; i <= 25000; i++) {
                            // Populate an model with some demo data
                            console.debug("populating: " + i)
                            testModel.append({
                                                 index: i,
                                                 value: "Some text"
                                             })
                        }
                        listView.model = testModel
                    }
                }
                /** The moment you press on this button
                  you can see console.log with delegate creations
                  */
                Button {
                    text: "new page"
                    onClicked: {
                        pageStack.push(emptyPage)
                    }
                }
            }

            // Empty model until populated
            ListModel {
                id: testModel
            }
        }
    }

    // Just an empty page for demonstration
    Component {
        id: emptyPage
        Page {
        }
    }

    initialPage: mainPage
}
