#include <stdio.h>
#include <stdlib.h>
#include <sched.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <libgen.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#include <linux/unistd.h>

#ifndef CLONE_NEWNET
#define CLONE_NEWNET		0x40000000
#endif

#define	STACKSIZE	16384

static const char* procname;

static void usage(const char *name)
{
	printf("usage: %s [-h] [command [arg ...]]\n", name);
	printf("  -h		this message\n");
	printf("  -n <count>	number of interfaces (containers) to create (default 1)\n");
	printf("  -t		create a thread per container (instead of a process)\n");
	printf("		Note: implies -c\n");
	printf("  -c		create containers (otherwise just create interfaces)\n");
	exit(1);
}

int sleeper(void)
{
    for (;;)
	sleep(100);
}

int child_func(void *arg)
{
    sleeper();
}

int create_interface (int index)
{
	char ifname[32];
	char *cmd[] = { "ip", "link", "add", ifname, "type", "ctx", NULL };
	int rv, status;

	sprintf(ifname, "ctx%d", index);

	if ((rv = fork()) == 0)
		execvp(cmd[0], cmd);
	else if (rv > 0) {
		wait(&status);
		if (WEXITSTATUS(status))
			rv = -1;
	}
	return rv;
}

int assign_interface (int index, int pid)
{
	char ifname[32];
        char pidstr[32];
	char *cmd[] = { "ip", "link", "set", ifname, "netns", pidstr, NULL };
	int rv, status;

	sprintf(ifname, "ctx%d", index);
	sprintf(pidstr, "%d", pid);
	if ((rv = fork()) == 0)
		execvp(cmd[0], cmd);
	else if (rv > 0) {
		wait(&status);
		if (WEXITSTATUS(status))
			rv = -1;
	}
	return rv;
}

void handle_sig(int whatever)
{	
	exit(0);
}
 
int main(int argc, char *argv[])
{	
	int c, pid;
	// int cloneflags = CLONE_FILES|CLONE_FS|CLONE_VM|CLONE_NEWNET;
	int cloneflags = CLONE_NEWNET;
	char *ifname;
	int i, ifcount = 1;
	int doclone = 0;
	int dothread = 0;
	int dox = 0;

	procname = basename(argv[0]);

	while ((c = getopt(argc, argv, "xcthn:")) != EOF) {
		switch (c) {
		case 'c':
			doclone = 1;
			break;
		case 't':
			doclone = 1;
			dothread = 1;
			cloneflags |= CLONE_THREAD|CLONE_SIGHAND|CLONE_VM;
			break;
		case 'x':
			dox = 1;
			break;
		case 'n':
			ifcount = atoi(optarg);
			break;
		case 'h':
		default:
			usage(procname);
		}
	};
    
	argv = &argv[optind];		// maybe for later
	argc = argc - optind;		// maybe for later

	if (dothread) {
	    int rv;
	    if ((rv=fork()) > 0) {		// parent
		signal(SIGUSR1, handle_sig);
		sleeper();
		exit(0);
	    } else if (rv < 0) {
		perror("fork");
		exit(1);
	    }
	}
	for (i=1; i<=ifcount; i++) {
	    if (create_interface(i) < 0) {
		fprintf(stderr, "Could not create interface ctx%d\n", i);
		exit(1);
	    }
	    if (doclone) {
	        if ((pid=clone(child_func, (char *)malloc(STACKSIZE) + STACKSIZE - 4, cloneflags, NULL)) <= 0) {
	            perror("clone");
	            exit(1);
	        }
	        if (!dox && assign_interface(i, pid) < 0) {
		    fprintf(stderr, "Could not assign interface ctx%d to cloned process\n", i);
		    exit(1);
	        }
	    } }
	if (dothread) {
		kill(getppid(), SIGUSR1);
		sleeper();
	}
	return 0;
}

