
CREATE TABLE metadean_nodes (
	node_id bigint AUTO_INCREMENT NOT NULL PRIMARY KEY,
	node_name varchar(32) NOT NULL,
	node_password varchar(24),
	node_city varchar(32) NOT NULL,
	node_state varchar(32) NOT NULL,
	node_zips text,
	node_country varchar(32) default "USA",
	node_virtuality set("Local", "Virtual", "Both") DEFAULT "Both",
	node_keywords text,
	node_type set("Community", "Personal", "Guild", "Official") DEFAULT "Community",
	node_description text,
	node_url varchar(255),
	node_fordean varcher(255),
	node_email varchar(255),
	node_captain bigint UNIQUE, #this should correspond to the talent table talent_id
	node_feeds text,
	node_media bool DEFAULT 0,
	node_created timestamp DEFAULT "NOW()",
	node_updated timestamp DEFAULT "NOW()",
	node_content mediumtext
);

# the node_feeds text is a 2d array which works like this: title#url|title#url
# so that means no pipes or hashmarks in the titles or urls
# but that shouldn't be a problem

CREATE TABLE metadean_talent (
	talent_id bigint AUTO_INCREMENT NOT NULL PRIMARY KEY,
	talent_first_name varcher(32) NOT NULL,
	talent_last_name varcher(32) NOT NULL,
	talent_city varchar(32) NOT NULL,
	talent_state varchar(32) NOT NULL,
	talent_zip int NOT NULL,
	talent_country varchar(32) default "USA",
	talent_travel bool,
	talent_distance int,
	talent_email varchar(255) NOT NULL,
	talent_phone varchar(20),
	talent_im_name varchar(32),
	talent_im_service varchar(32),
	talent_url varchar(255),
	talent_preferred_contact varchar(255),
	talent_bio text,
	talent_birthdate date,
	talent_online set("Always", "Often", "Daily", "Weekly", "Less"),
	talent_involvement set("On Campaign", "Volunteer Organizer", "Volunteer", "Interested", "Just Looking")
	talent_skills text, 
	talent_rating float,
	talent_notes text #for internal use
)

# talent_skills is another array/list where we give a lot of useful defaults
# but allow the addition of "others" I figure it's a 1d array and we do it 
# with newlines