/*
  TODO : mounted should be a subset of Changed
 */
gboolean prop_equal_common(DeviceProperties *a, DeviceProperties *b);
gboolean prop_equal_on_added(DeviceProperties *a, DeviceProperties *b);
gboolean prop_equal_on_mounted(DeviceProperties *a, DeviceProperties *b);
Setting *prop_from_mount_paths(gchar *mp,  Setting **b, gchar *evt);
gboolean have_common_mount_path(gchar **a, gchar **b);
gboolean have_common_mount_path2(gchar **a, const gchar *b);
void print_duplicates(Setting **a);

// Properties taken into account
// "NativePath",    "DeviceFile",    "DeviceFileById",   "DeviceFileByPath"
gboolean prop_equal_common(DeviceProperties *a, DeviceProperties *b) {
  if ( a->native_path!=NULL && b->native_path != NULL && strcmp(a->native_path,b->native_path) != 0)
    return FALSE;
  if ( a->device_file!=NULL && b->device_file != NULL && strcmp(a->device_file,b->device_file) != 0)
    return FALSE;
  if ( a->device_file_by_id!=NULL && b->device_file_by_id != NULL && strcmp(a->device_file_by_id[0],b->device_file_by_id[0]) != 0)
    return FALSE;
  if ( a->device_file_by_path!=NULL && b->device_file_by_path != NULL && strcmp(a->device_file_by_path[0],b->device_file_by_path[0]) != 0)
    return FALSE;
  return TRUE;
}

//  "DeviceIsRemovable", "DeviceSize", "DriveVendor", "DriveModel", "DriveRevision", "DriveSerial"
/* the omitable DeviceProperty should be the 1st arg (the config file one) 
 to make device_is_removable to work */
gboolean prop_equal_on_added(DeviceProperties *a, DeviceProperties *b) {
  if(!prop_equal_common(a,b))
    return FALSE;
  if ( a->device_is_removable && !b->device_is_removable)
    return FALSE;
  if  ( a->device_size !=0 && b->device_size != 0 && a->device_size == b->device_size )
    return FALSE;
  if ( a->drive_vendor!=NULL && b->drive_vendor != NULL && strcmp(a->drive_vendor,b->drive_vendor) != 0)
    return FALSE;
  if ( a->drive_model!=NULL && b->drive_model != NULL && strcmp(a->drive_model,b->drive_model) != 0)
    return FALSE;
  if ( a->drive_revision!=NULL && b->drive_revision != NULL && strcmp(a->drive_revision,b->drive_revision) != 0)
    return FALSE;
  if ( a->drive_serial!=NULL && b->drive_serial != NULL && strcmp(a->drive_serial,b->drive_serial) != 0)
    return FALSE;
  return TRUE;
}

//  "DeviceIsMounted", "DeviceMountPaths", "DeviceSize", "PartitionSize", "IdUuid", "IdLabel"
/* the omitable DeviceProperty should be the 1st arg (the config file one) 
   to make device_is_mounted to work */
/*
  TODO : find a way to let configuration check the constraint "NOT device_is_mounted"
  TODO : get the device event props from the mountpath
  (until then, let's (only) use 
*/
gboolean prop_equal_on_mounted(DeviceProperties *a, DeviceProperties *b) {
  if(!prop_equal_common(a,b))
    return FALSE;
  if ( a->device_is_mounted  && ! b->device_is_mounted )
    return FALSE;
  // should compare full string
  if ( a->partition_size !=0 && b->partition_size != 0 && a->partition_size == b->partition_size )
    return FALSE;
  if ( a->id_uuid!=NULL && b->id_uuid != NULL && strcmp(a->id_uuid,b->id_uuid) != 0)
    return FALSE;
  if ( a->id_label!=NULL && b->id_label != NULL && strcmp(a->id_label,b->id_label) != 0)
    return FALSE;
  if ( a->device_mount_paths!=NULL && !have_common_mount_path(a->device_mount_paths,b->device_mount_paths))
    return FALSE;

  return TRUE;
}


gboolean have_common_mount_path(gchar **a, gchar **b) {
  int i = 0, j = 0;
  while (a[i] != NULL) {
    while (b[j] != NULL) {
      if(strcmp(a[i],b[j]) == 0)
	return TRUE;
      j++;
    }
    j=0; i++;
  }
  return FALSE;
}

gboolean have_common_mount_path2(gchar **a, const gchar *b) {
  if(a == NULL) {
    // means we have other event triggered on DeviceMounted or DeviceUnmounted
    // but they DID NOT specify any mount point (which is currently the only matchable property)
    // g_print("[have_common_mount_path2][un]mount event happens unmatched against %s\n",b);
    return FALSE;
  }
  int i = 0;
  while (a[i] != NULL)
    if(strcmp(a[i++],b) == 0)
      return TRUE;
  return FALSE;
}


/*Setting *prop_from_mount_paths(gchar *mp,  Setting **b, gchar *evt) {
  }*/

void print_duplicates(Setting **a) {
  int i, j;
  for (i=0;i<MAX_SETTINGS;i++) {
    if(a[i] == NULL) continue;
    for (j=0;j<MAX_SETTINGS;j++) {
      if(a[j] == NULL) continue;
      g_print("COMPARE : %s <-> %s : ", a[i]->nickname, a[j]->nickname);
      if (prop_equal_common(a[i]->dp,a[j]->dp) && prop_equal_on_added(a[i]->dp,a[j]->dp) && prop_equal_on_mounted(a[i]->dp,a[j]->dp))
	g_print(" ==\n");
      else
	g_print(" !=\n");
    }
  }
}
