/*
Compile with :
gcc -Wall -ggdb -I/usr/include/dbus-1.0 -I/usr/include/glib-2.0 -I/usr/lib64/glib-2.0/include -ldbus-glib-1  -o  devkit-disks-trigger devkit-disks-trigger.c
*/

#include "DeviceKit-disks/config.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <glib.h>
#include <dbus/dbus-glib.h>
#include <glib/gstdio.h>

/* replace with the correct location */
#include "DeviceKit-disks/tools/devkit-disks-marshal.c"
#include "DeviceKit-disks/src/devkit-disks-mount.c"
#include "DeviceKit-disks/src/devkit-disks-mount-monitor.h"
#include "DeviceKit-disks/src/devkit-disks-mount-monitor.c"
//#include "devkit-disks.c"
#include "devkit-disks-duplicates.c"
#include "devkit-disks-trigger.h"
void collect_props_from_gkfile(DeviceProperties *dp, GKeyFile *gkf);
#include "Setting.c"
#include "Comparator.c"

Setting **settings;
DevkitDisksMountMonitor *mount_monitor;

static DBusGConnection     *bus = NULL;
static DBusGProxy          *disks_proxy = NULL;
static GMainLoop           *loop;

void init_callbacks (void) {
   if(is_one_setting_match_on_event(settings, "DeviceUnmounted") || 
     is_one_setting_match_on_event(settings, "DeviceMounted"))
    mount_monitor = devkit_disks_mount_monitor_new ();

  if(is_one_setting_match_on_event(settings, "DeviceMounted"))
    g_signal_connect (mount_monitor, "mount-added", (GCallback) mount_added, NULL);
  if(is_one_setting_match_on_event(settings, "DeviceUnmounted"))
    g_signal_connect (mount_monitor, "mount-removed", (GCallback) mount_removed, NULL);

  /* TODO : why mandatory to get the first mount event ? */
  devkit_disks_mount_monitor_ensure(mount_monitor);

  /*
    attach to event only if one of the Settings looks for it
   */
  if(is_one_setting_match_on_event(settings, "DeviceAdded"))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceAdded",
				 G_CALLBACK (device_added_signal_handler), NULL, NULL);

  if(is_one_setting_match_on_event(settings, "DeviceRemoved"))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceRemoved",
				 G_CALLBACK (device_removed_signal_handler), NULL, NULL);

  if(is_one_setting_match_on_event(settings, "DeviceChanged"))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceChanged",
				 G_CALLBACK (device_changed_signal_handler), NULL, NULL);

  dbus_g_proxy_connect_signal (disks_proxy, "DeviceJobChanged",
			       G_CALLBACK (device_job_changed_signal_handler), NULL, NULL);

}

gboolean init_dbus() {
  GError              *error = NULL;
  g_type_init ();

  loop = g_main_loop_new (NULL, FALSE);
  bus = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
  if (bus == NULL) {
    g_warning ("Couldn't connect to system bus: %s", error->message);
    g_error_free (error);
    return FALSE;
  }
  dbus_g_object_register_marshaller (
				     devkit_disks_marshal_VOID__BOXED_BOOLEAN_STRING_UINT_BOOLEAN_DOUBLE,
				     G_TYPE_NONE,
				     DBUS_TYPE_G_OBJECT_PATH,
				     G_TYPE_BOOLEAN,
				     G_TYPE_STRING,
				     G_TYPE_UINT,
				     G_TYPE_BOOLEAN,
				     G_TYPE_DOUBLE,
				     G_TYPE_INVALID);

  disks_proxy = dbus_g_proxy_new_for_name (bus,
					   "org.freedesktop.DeviceKit.Disks",
					   "/org/freedesktop/DeviceKit/Disks",
					   "org.freedesktop.DeviceKit.Disks");


  if(is_one_setting_match_on_event(settings, "DeviceAdded"))
    dbus_g_proxy_add_signal (disks_proxy, "DeviceAdded", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);
  if(is_one_setting_match_on_event(settings, "DeviceRemoved"))
    dbus_g_proxy_add_signal (disks_proxy, "DeviceRemoved", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);

  //if(is_one_setting_match_on_event(settings, "DeviceChanged"))
    dbus_g_proxy_add_signal (disks_proxy, "DeviceChanged", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);

  dbus_g_proxy_add_signal (disks_proxy, "DeviceJobChanged", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_BOOLEAN,
			   G_TYPE_STRING,
			   G_TYPE_UINT,
			   G_TYPE_BOOLEAN,
			   G_TYPE_DOUBLE,
			   G_TYPE_INVALID);
  return TRUE;
}

/* two helpers */
void print_str(char **plop) {
  int i;
  for(i=0;i<MAX_CMDLINE_ARGS;i++) {
    if(plop[i] != NULL)
      g_print("%s ", plop[i]);
    else
      break;
  }
}

/*
  argument are the Setting and one of its own signals
  each event handler should find its own and make the needed
  match tests
  come here if  :
  1) the event type (removed, mounted, ...) match the one of its signal event_name attribute
  2) and the characteristics of the device match the Setting->DeviceProperties struct
 */
void final_fork_handler(Setting *a, Signal *s) {
  pid_t pid;

  if(DEBUG) {
    g_print("MATCH: [%s]\t(%s):\t'",a->nickname,s->event_name);
    print_str(s->to_exec);
    g_print("'\n");
  }
  (s->happened)++;
  
  pid = fork ();
  if (pid > 0)
    g_print("[final_fork_handler]fork\n");
  else if (pid == 0) {
    if(execvp (s->to_exec[0], s->to_exec) != 0)
      g_warning("[final_fork_handler]exec failed !\n");
  } else
    g_warning("[final_fork_handler]cannot fork\n");
}

static void device_added_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  DeviceProperties *props = device_properties_get(bus, object_path);
  Signal *sig;
  int i;
  g_print ("added:     %s\n", object_path);
  if(DEBUG)
    do_show_info_device_property (props);
  for (i=0;i<MAX_SETTINGS && settings[i] != NULL;i++) {
    if((sig = setting_match_on_event(settings[i], "DeviceAdded")) != NULL &&
       prop_equal_on_added(settings[i]->dp,props)) {
      // only for ADDED, as it's the only event which let us grab props
      process_cmd_line(sig->to_exec, props);
      final_fork_handler(settings[i],sig);
    }
  }
  g_print("[added]free prop\n"); 
  g_free(props);
  //device_common_signal_handler("DeviceAdded", object_path);
}
static void device_removed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  g_print ("removed:   %s\n", object_path);
}

static void device_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  g_print ("changed:     %s\n", object_path);
}

static void device_job_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gboolean    job_in_progress,
					       const char *job_id, guint32     job_initiated_by_uid, gboolean    job_is_cancellable,
					       double      job_percentage, gpointer    user_data) {
  g_print ("job-changed: %s\n", object_path);
  /*if (opt_monitor_detail) {
    print_job (job_in_progress,
    job_id,
    job_initiated_by_uid,
    job_is_cancellable,
    job_percentage);
    }*/
}

static void mount_added (DevkitDisksMountMonitor *monitor, DevkitDisksMount *mount, gpointer user_data) {
  Signal *sig;
  int i;
  const gchar *evtmp = devkit_disks_mount_get_mount_path(mount);
  g_print("[!!]mounted %s\n", evtmp);
  /*
    // if able to grab the property from a simple mount_path
    DeviceProperties *props = device_properties_get(bus,  #SOMETHING#);
    if(DEBUG)
    do_show_info_device_property (props);
  */
  for (i=0; i<MAX_SETTINGS && settings[i] != NULL; i++) {
    if((sig = setting_match_on_event(settings[i], "DeviceMounted")) != NULL &&
       // prop_equal_on_mounted(settings[i]->dp,props))
       have_common_mount_path2(settings[i]->dp->device_mount_paths, evtmp)) {
      final_fork_handler(settings[i],sig);
    }
  }
  /*g_print("[added]free prop\n"); 
    g_free(props);*/
}

static void mount_removed (DevkitDisksMountMonitor *monitor, DevkitDisksMount *mount, gpointer user_data) {
  Signal *sig;
  int i;
  const gchar *evtmp = devkit_disks_mount_get_mount_path(mount);
  g_print("[!!]unmounted %s\n", evtmp);
  for (i=0; i<MAX_SETTINGS && settings[i] != NULL; i++) {
    if((sig = setting_match_on_event(settings[i], "DeviceUnmounted")) != NULL &&
       have_common_mount_path2(settings[i]->dp->device_mount_paths, evtmp))
      final_fork_handler(settings[i],sig);
  }
}


int main (int argc, char **argv) {
  GError *error = NULL;
  const gchar *filename;
  gchar *fullpath;
  GDir *dir;
  int i = 0;
  
  settings = g_new0(Setting,MAX_SETTINGS);
  if(argc==2) {
    if(DEBUG)
      g_print("opening %s\n",argv[1]);
  }
  else {
    g_print("Usage: %s <FILE|DIRECTORY>\n",argv[0]);
    return 1;
  }

  /* arg is a file */
  i=1;
  if (g_file_test (argv[1], G_FILE_TEST_IS_REGULAR)) {
    settings_init(argv[1],settings);
    settings_show_info(settings);
  }
  /* arg is a dir, load all subfiles */
  else if (g_file_test (argv[1], G_FILE_TEST_IS_DIR)) {
    dir = g_dir_open(argv[1],0,&error);
    if (error) {
      g_printerr ("g_dir_open(%s) failed - %s\n", argv[1], error->message);
      g_error_free(error);
      return -1;
    }
    while((filename = g_dir_read_name(dir)) && i<MAX_SETTINGS) {
      if(DEBUG)
	g_print("proceed %s\n",filename);

      if (g_path_is_absolute (filename))
	fullpath = g_strdup (filename);
      else
	fullpath = g_build_filename (argv[1], filename, NULL);

      if (g_file_test (fullpath, G_FILE_TEST_IS_REGULAR))
	settings_init(fullpath,settings);
      g_free(fullpath);
    }
    g_dir_close(dir);
  }
  else
    g_error("Cannot stat %s\n",argv[1 ]);

  if (init_dbus())  {
    init_callbacks();
    g_print ("Monitoring activity from the disks daemon. Press Ctrl+C to cancel.\n");
    g_print("main loop\n");
    g_main_loop_run (loop);
  }




  g_print("free sets\n");
  for (i=0;i<MAX_SETTINGS;i++)
    if(settings[i] != NULL)
      setting_free(settings[i]);
  g_print("free proxy\n");

  if (disks_proxy != NULL)
    g_object_unref (disks_proxy);
  if (bus != NULL)
    dbus_g_connection_unref (bus);
  return 0;
}
