#include <string.h>

#define MAX_SETTINGS 8
#define DEBUG TRUE

// signalnames size (below)
#define SIGNAL_COUNT 4
// keynames size (below)
#define PROP_COUNT 15

#define MAX_CMDLINE_ARGS 64

//static void device_common_signal_handler(gchar *event, const gchar *object_path);
static void device_added_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data);
static void device_removed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data);
static void device_job_changed_signal_handler (DBusGProxy *proxy,
					       const char *object_path,
					       gboolean    job_in_progress,
					       const char *job_id,
					       guint32     job_initiated_by_uid,
					       gboolean    job_is_cancellable,
					       double      job_percentage,
					       gpointer    user_data);
static void device_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data);
static void mount_added (DevkitDisksMountMonitor *monitor, DevkitDisksMount *mount, gpointer user_data);
static void mount_removed (DevkitDisksMountMonitor *monitor, DevkitDisksMount *mount, gpointer user_data);

gboolean init_dbus (void);
void init_callbacks (void);
void process_cmd_line(char ** to_exec, DeviceProperties *props);

// Properties taken into account
char *keynames[] = {
  "NativePath",
  "DeviceFile",
  "DeviceFileById",
  "DeviceFileByPath",
  "DeviceIsRemovable",
  "DeviceIsMounted",
  "DeviceMountPaths",
  "DeviceSize",
  "PartitionSize",
  "IdUuid",
  "IdLabel",
  "DriveVendor",
  "DriveModel",
  "DriveRevision",
  "DriveSerial"};
// how many they are (C noob style)
char *signalnames[] = {
  "DeviceAdded",
  "DeviceRemoved",
  /*   DeviceChanged, */
  "DeviceMounted",
  "DeviceUnmounted"};

/* from devkit-disks.c
   modified to take a DeviceProperties as argument
*/
static void do_show_info_device_property (DeviceProperties *props) {
  guint n;
  struct tm *time_tm;
  time_t time;
  char time_buf[256];

  if (props == NULL)
    return;

  time = (time_t) props->device_detection_time;
  time_tm = localtime (&time);
  strftime (time_buf, sizeof time_buf, "%c", time_tm);

  //      g_print ("Showing information for %s\n", object_path);
  g_print ("  native-path:                 %s\n", props->native_path);
  g_print ("  device:                      %" G_GINT64_MODIFIER "d:%" G_GINT64_MODIFIER "d\n",
	   props->device_major,
	   props->device_minor);
  g_print ("  device-file:                 %s\n", props->device_file);
  for (n = 0; props->device_file_by_id!=NULL && props->device_file_by_id[n] != NULL; n++)
    g_print ("    by-id:                     %s\n", (char *) props->device_file_by_id[n]);
  for (n = 0; props->device_file_by_path!=NULL && props->device_file_by_path[n] != NULL; n++)
    g_print ("    by-path:                   %s\n", (char *) props->device_file_by_path[n]);
  g_print ("  detected at:                 %s\n", time_buf);
  g_print ("  system internal:             %d\n", props->device_is_system_internal);
  g_print ("  removable:                   %d\n", props->device_is_removable);
  g_print ("  has media:                   %d", props->device_is_media_available);
  if (props->device_media_detection_time != 0) {
    time = (time_t) props->device_media_detection_time;
    time_tm = localtime (&time);
    strftime (time_buf, sizeof time_buf, "%c", time_tm);
    g_print (" (detected at %s)", time_buf);
  }
  g_print ("\n");
  g_print ("    detects change:            %d\n", props->device_is_media_change_detected);
  g_print ("    detection by polling:      %d\n", props->device_is_media_change_detection_polling);
  g_print ("    detection inhibitable:     %d\n", props->device_is_media_change_detection_inhibitable);
  g_print ("    detection inhibited:       %d\n", props->device_is_media_change_detection_inhibited);
  g_print ("  is read only:                %d\n", props->device_is_read_only);
  g_print ("  is mounted:                  %d\n", props->device_is_mounted);
  g_print ("  mount paths:             ");
  for (n = 0; props->device_mount_paths != NULL && props->device_mount_paths[n] != NULL; n++) {
    if (n != 0)
      g_print (", ");
    g_print ("%s", props->device_mount_paths[n]);
  }
  g_print ("\n");
  g_print ("  mounted by uid:              %d\n", props->device_mounted_by_uid);
  g_print ("  presentation hide:           %d\n", props->device_presentation_hide);
  g_print ("  presentation nopolicy:       %d\n", props->device_presentation_nopolicy);
  g_print ("  presentation name:           %s\n", props->device_presentation_name);
  g_print ("  presentation icon:           %s\n", props->device_presentation_icon_name);
  g_print ("  size:                        %" G_GUINT64_FORMAT "\n", props->device_size);
  g_print ("  block size:                  %" G_GUINT64_FORMAT "\n", props->device_block_size);

  print_job (props->job_in_progress,
	     props->job_id,
	     props->job_initiated_by_uid,
	     props->job_is_cancellable,
	     props->job_percentage);
  g_print ("  usage:                       %s\n", props->id_usage);
  g_print ("  type:                        %s\n", props->id_type);
  g_print ("  version:                     %s\n", props->id_version);
  g_print ("  uuid:                        %s\n", props->id_uuid);
  g_print ("  label:                       %s\n", props->id_label);
  if (props->device_is_linux_md_component) {
    g_print ("  linux md component:\n");
    g_print ("    RAID level:                %s\n", props->linux_md_component_level);
    g_print ("    num comp:                  %d\n", props->linux_md_component_num_raid_devices);
    g_print ("    uuid:                      %s\n", props->linux_md_component_uuid);
    g_print ("    home host:                 %s\n", props->linux_md_component_home_host);
    g_print ("    name:                      %s\n", props->linux_md_component_name);
    g_print ("    version:                   %s\n", props->linux_md_component_version);
    g_print ("    holder:                    %s\n",
	     g_strcmp0 (props->linux_md_component_holder, "/") == 0 ? "(none)" : props->linux_md_component_holder);
    g_print ("    state:                     ");
    for (n = 0;
	 props->linux_md_component_state != NULL && props->linux_md_component_state[n] != NULL;
	 n++) {
      if (n > 0)
	g_print (", ");
      g_print ("%s", props->linux_md_component_state[n]);
    }
    g_print ("\n");
  }
  if (props->device_is_linux_md) {
    g_print ("  linux md:\n");
    g_print ("    state:                     %s\n", props->linux_md_state);
    g_print ("    RAID level:                %s\n", props->linux_md_level);
    g_print ("    uuid:                      %s\n", props->linux_md_uuid);
    g_print ("    home host:                 %s\n", props->linux_md_home_host);
    g_print ("    name:                      %s\n", props->linux_md_name);
    g_print ("    num comp:                  %d\n", props->linux_md_num_raid_devices);
    g_print ("    version:                   %s\n", props->linux_md_version);
    g_print ("    degraded:                  %d\n", props->linux_md_is_degraded);
    g_print ("    sync action:               %s\n", props->linux_md_sync_action);
    if (strcmp (props->linux_md_sync_action, "idle") != 0) {
      g_print ("      complete:                %3.01f%%\n", props->linux_md_sync_percentage);
      g_print ("      speed:                   %" G_GINT64_FORMAT " bytes/sec\n", props->linux_md_sync_speed);
    }
    g_print ("    slaves:\n");
    for (n = 0; props->linux_md_slaves[n] != NULL; n++)
      g_print ("                      %s\n", props->linux_md_slaves[n]);
  }
  if (props->device_is_luks) {
    g_print ("  luks device:\n");
    g_print ("    holder:                    %s\n", props->luks_holder);
  }
  if (props->device_is_luks_cleartext) {
    g_print ("  cleartext luks device:\n");
    g_print ("    backed by:                 %s\n", props->luks_cleartext_slave);
    g_print ("    unlocked by:               uid %d\n", props->luks_cleartext_unlocked_by_uid);
  }
  if (props->device_is_partition_table) {
    g_print ("  partition table:\n");
    g_print ("    scheme:                    %s\n", props->partition_table_scheme);
    g_print ("    count:                     %d\n", props->partition_table_count);
  }
  if (props->device_is_partition) {
    g_print ("  partition:\n");
    g_print ("    part of:                   %s\n", props->partition_slave);
    g_print ("    scheme:                    %s\n", props->partition_scheme);
    g_print ("    number:                    %d\n", props->partition_number);
    g_print ("    type:                      %s\n", props->partition_type);
    g_print ("    flags:                ");
    for (n = 0; props->partition_flags[n] != NULL; n++)
      g_print (" %s", (char *) props->partition_flags[n]);
    g_print ("\n");
    g_print ("    offset:                    %" G_GINT64_FORMAT "\n", props->partition_offset);
    g_print ("    size:                      %" G_GINT64_FORMAT "\n", props->partition_size);
    g_print ("    label:                     %s\n", props->partition_label);
    g_print ("    uuid:                      %s\n", props->partition_uuid);
  }
  if (props->device_is_optical_disc) {
    g_print ("  optical disc:\n");
    g_print ("    blank:                     %d\n", props->optical_disc_is_blank);
    g_print ("    appendable:                %d\n", props->optical_disc_is_appendable);
    g_print ("    closed:                    %d\n", props->optical_disc_is_closed);
    g_print ("    num tracks:                %d\n", props->optical_disc_num_tracks);
    g_print ("    num audio tracks:          %d\n", props->optical_disc_num_audio_tracks);
    g_print ("    num sessions:              %d\n", props->optical_disc_num_sessions);
  }
  if (props->device_is_drive) {
    g_print ("  drive:\n");
    g_print ("    vendor:                    %s\n", props->drive_vendor);
    g_print ("    model:                     %s\n", props->drive_model);
    g_print ("    revision:                  %s\n", props->drive_revision);
    g_print ("    serial:                    %s\n", props->drive_serial);
    g_print ("    detachable:                %d\n", props->drive_can_detach);
    g_print ("    can spindown:              %d\n", props->drive_can_spindown);
    g_print ("    rotational media:          %d\n", props->drive_is_rotational);
    g_print ("    ejectable:                 %d\n", props->drive_is_media_ejectable);
    g_print ("    media:                     %s\n", props->drive_media);
    g_print ("      compat:                 ");
    for (n = 0; props->drive_media_compatibility != NULL && props->drive_media_compatibility[n] != NULL; n++)
      g_print (" %s", (char *) props->drive_media_compatibility[n]);
    g_print ("\n");
    if (props->drive_connection_interface == NULL || strlen (props->drive_connection_interface) == 0)
      g_print ("    interface:                 (unknown)\n");
    else
      g_print ("    interface:                 %s\n", props->drive_connection_interface);
    if (props->drive_connection_speed == 0)
      g_print ("    if speed:                  (unknown)\n");
    else
      g_print ("    if speed:                  %" G_GINT64_FORMAT " bits/s\n", props->drive_connection_speed);

    /* ------------------------------------------------------------------------------------------------- */

    if (!props->drive_ata_smart_is_available) {
      g_print ("    ATA SMART:                 not available\n");
    } else if (props->drive_ata_smart_time_collected == 0) {
      g_print ("    ATA SMART:                 Data not collected\n");
    } else {
      g_print ("    ATA SMART:                 Won't collect data\n");
    }
  }
}


void process_cmd_line(char ** to_exec, DeviceProperties *props) {
  int i;
  //  GValue dest_value = {0};
  g_print("[process_cmd_line]starts\n");
  for(i=0;i<MAX_CMDLINE_ARGS;i++) {
    if(to_exec[i] == NULL)
      break;

    /*
      for i in native_path device_file id_usage id_type id_version id_uuid id_label partition_uuid partition_label; do
      echo "
      if(strcmp(to_exec[i],\"%$i\") == 0) {
      if(DEBUG)
      g_print(\"[process_cmd_line]substitution : %s => %s\n\",to_exec[i],props->$i);
      g_stpcpy(to_exec[i],props->$i);
      }";
      done;

      # to much warning with this => not used currently
      for i in device_is_system_internal device_is_removable device_is_media_available device_is_read_only device_is_mounted device_mounted_by_uid partition_table_count partition_number drive_can_detach drive_can_spindown; do
      echo "
      g_type_init ();
      g_value_init (&dest_value, G_TYPE_INT);
      g_value_set_int (&dest_value, props->$i);
      if(strcmp(to_exec[i],\"%$i\") == 0) {
      if(DEBUG)
      g_print(\"[process_cmd_line]substitution : %s => %s\n\",to_exec[i],g_strdup_value_contents(&dest_value));
      g_stpcpy(to_exec[i],g_strdup_value_contents(&dest_value));
      g_value_unset(&dest_value);
      }";
      done;
     
      for i in device_media_detection_time partition_size; do
      echo "
      g_type_init ();
      g_value_init (&dest_value, G_TYPE_UINT64);
      g_value_set_uint64 (&dest_value, props->$i);
      if(strcmp(to_exec[i],\"%$i\") == 0) {
      if(DEBUG)
      g_print(\"[process_cmd_line]substitution : %s => %s\n\",to_exec[i],g_strdup_value_contents(&dest_value));
      g_stpcpy(to_exec[i],g_strdup_value_contents(&dest_value));
      g_value_unset(&dest_value);
      }";
      done;
    */


    if(strcmp(to_exec[i],"%native_path") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->native_path);
      g_stpcpy(to_exec[i],props->native_path);
    }

    if(strcmp(to_exec[i],"%device_file") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->device_file);
      g_stpcpy(to_exec[i],props->device_file);
    }

    if(strcmp(to_exec[i],"%id_usage") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->id_usage);
      g_stpcpy(to_exec[i],props->id_usage);
    }

    if(strcmp(to_exec[i],"%id_type") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->id_type);
      g_stpcpy(to_exec[i],props->id_type);
    }

    if(strcmp(to_exec[i],"%id_version") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->id_version);
      g_stpcpy(to_exec[i],props->id_version);
    }

    if(strcmp(to_exec[i],"%id_uuid") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->id_uuid);
      g_stpcpy(to_exec[i],props->id_uuid);
    }

    if(strcmp(to_exec[i],"%id_label") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->id_label);
      g_stpcpy(to_exec[i],props->id_label);
    }

    if(strcmp(to_exec[i],"%partition_uuid") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->partition_uuid);
      g_stpcpy(to_exec[i],props->partition_uuid);
    }

    if(strcmp(to_exec[i],"%partition_label") == 0) {
      if(DEBUG)
	g_print("[process_cmd_line]substitution : %s => %s\n",to_exec[i],props->partition_label);
      g_stpcpy(to_exec[i],props->partition_label);
    }

  }
}
