#ifndef SETTING_H
#define SETTING_H

#include "Signal.h"

typedef struct {
  gchar nickname[50];
  DeviceProperties *dp;
  Signal *signal[SIGNAL_COUNT];
  //Signal **signal;
} Setting;


GKeyFile *settings_init_file(gchar *filename);
DeviceProperties *setting_init_dp(GKeyFile *gfk, gchar *group);
void settings_init(gchar *filename, Setting **settings, Action **catchall_array);


void settings_init_old(gchar *filename, Setting **settings);
void setting_free(Setting *s);
void settings_free(Setting **s);

void setting_show_info(Setting *a);
//gboolean is_one_setting_match_on_event(Setting **a, gchar *evt);
gboolean is_one_setting_match_on_event(Setting **a, int evt);
Signal *setting_match_on_event(Setting *a, int evt);
gboolean collect_props_from_gkfile2(DeviceProperties *dp, GKeyFile *gkf, gchar *entry);
#endif
