#ifndef SIGNAL_H
#define SIGNAL_H

#include "Action.h"

#define DEV_ADDED	(1<<0)
#define DEV_REMOVED	(1<<1)
#define DEV_CHANGED	(1<<2)
#define DEV_JOBCHANGED	(1<<3)
#define DEV_MOUNTED	(1<<4)
#define DEV_UNMOUNTED	(1<<5)

// TODO : remove
#define SIGNAL_COUNT 6

const static struct _sig {
  const char * const signame;
  int sigflag;
} sigs[] = {
  { "DeviceAdded",       DEV_ADDED },
  { "DeviceRemoved",     DEV_REMOVED },
  { "DeviceChanged",     DEV_CHANGED },
  { "DeviceJobChanged",  DEV_JOBCHANGED },
  { "DeviceMounted",     DEV_MOUNTED },
  { "DeviceUnmounted",   DEV_UNMOUNTED },
  { (char *)NULL, 0 },
};


typedef struct {
  int event_type;
  Action *action;
} Signal;

void show_signal_info(Signal *s);
void show_signals_info(Signal **ss);
void signal_free(Signal **signal);
const char *sigflag_to_signame(int t);

#endif
