/*
  Compile with :
  gcc -Wall -ggdb $(pkg-config --cflags --libs glib-2.0 dbus-glib-1) -o  devkit-disks-trigger devkit-disks-trigger.c
*/
/*
  TODO : get devname from mount point (for DEV_MOUNTED)
 */
#include "DeviceKit-disks/config.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <glib.h>
#include <dbus/dbus-glib.h>
#include <glib/gstdio.h>
#include <fstab.h>
#include <locale.h>

/* replace with the correct location */
#include "DeviceKit-disks/tools/devkit-disks-marshal.c"
#include "DeviceKit-disks/src/devkit-disks-mount.c"
#include "DeviceKit-disks/src/devkit-disks-mount-monitor.h"
#include "DeviceKit-disks/src/devkit-disks-mount-monitor.c"
//#include "devkit-disks.c"
#include "devkit-disks-duplicates.c"
#include "devkit-disks-trigger.h"

#include "Action.h"
#include "Setting.c"
#include "Comparator.c"


Action **catchalls;
Setting **settings;
DevkitDisksMountMonitor *mount_monitor;

static DBusGConnection     *bus = NULL;
static DBusGProxy          *disks_proxy = NULL;
static GMainLoop           *loop;

static gboolean      opt_debug                   = FALSE;
static gboolean      opt_dump                   = FALSE;
static gchar         **opt_filenames              = NULL;

void init_callbacks (void) {
  if(DEBUG)
    g_print("[init_callbacks]\n");
  if(is_one_setting_match_on_event(settings, DEV_UNMOUNTED) || 
     is_one_setting_match_on_event(settings, DEV_MOUNTED))
    mount_monitor = devkit_disks_mount_monitor_new ();

  if(is_one_setting_match_on_event(settings, DEV_MOUNTED))
    g_signal_connect (mount_monitor, "mount-added", (GCallback) mount_added, NULL);
  if(is_one_setting_match_on_event(settings, DEV_UNMOUNTED))
    g_signal_connect (mount_monitor, "mount-removed", (GCallback) mount_removed, NULL);

  /* TODO : why mandatory to get the first mount event ? */
  if(mount_monitor)
    devkit_disks_mount_monitor_ensure(mount_monitor);

  /*
    attach to event only if one of the Settings looks for it
  */

  if(is_one_setting_match_on_event(settings, DEV_ADDED))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceAdded",
				 G_CALLBACK (device_added_signal_handler), NULL, NULL);

  if(is_one_setting_match_on_event(settings, DEV_REMOVED))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceRemoved",
				 G_CALLBACK (device_removed_signal_handler), NULL, NULL);

  if(is_one_setting_match_on_event(settings, DEV_CHANGED))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceChanged",
				 G_CALLBACK (device_changed_signal_handler), NULL, NULL);

  if(is_one_setting_match_on_event(settings, DEV_JOBCHANGED))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceJobChanged",
				 G_CALLBACK (device_job_changed_signal_handler), NULL, NULL);

}

gboolean init_dbus() {
  if(DEBUG)
    g_print("[init_dbus]\n");
  GError              *error = NULL;
  g_type_init ();

  loop = g_main_loop_new (NULL, FALSE);
  bus = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
  if (!bus) {
    g_warning ("Couldn't connect to system bus: %s", error->message);
    g_error_free (error); error = NULL;
    return FALSE;
  }
  dbus_g_object_register_marshaller (
				     devkit_disks_marshal_VOID__BOXED_BOOLEAN_STRING_UINT_BOOLEAN_DOUBLE,
				     G_TYPE_NONE,
				     DBUS_TYPE_G_OBJECT_PATH,
				     G_TYPE_BOOLEAN,
				     G_TYPE_STRING,
				     G_TYPE_UINT,
				     G_TYPE_BOOLEAN,
				     G_TYPE_DOUBLE,
				     G_TYPE_INVALID);

  disks_proxy = dbus_g_proxy_new_for_name (bus,
					   "org.freedesktop.DeviceKit.Disks",
					   "/org/freedesktop/DeviceKit/Disks",
					   "org.freedesktop.DeviceKit.Disks");


  if(is_one_setting_match_on_event(settings, DEV_ADDED))
    dbus_g_proxy_add_signal (disks_proxy, "DeviceAdded", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);
  if(is_one_setting_match_on_event(settings, DEV_REMOVED))
    dbus_g_proxy_add_signal (disks_proxy, "DeviceRemoved", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);

  if(is_one_setting_match_on_event(settings, DEV_CHANGED))
  dbus_g_proxy_add_signal (disks_proxy, "DeviceChanged", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);

  if(is_one_setting_match_on_event(settings, DEV_JOBCHANGED))
  dbus_g_proxy_add_signal (disks_proxy, "Device_JobChanged", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_BOOLEAN,
			   G_TYPE_STRING,
			   G_TYPE_UINT,
			   G_TYPE_BOOLEAN,
			   G_TYPE_DOUBLE,
			   G_TYPE_INVALID);
  return TRUE;
}


static void device_added_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  DeviceProperties *props = device_properties_get(bus, object_path);
  Signal *sig;
  int i;
  g_print ("added:     %s\n", object_path);
  if(DEBUG)
    do_show_info_device_property (props);
  for (i=0;i<MAX_SETTINGS && settings[i];i++) {
    if((sig = setting_match_on_event(settings[i], DEV_ADDED)) &&
       prop_equal_on_added(settings[i]->dp,props)) {
      // only for ADDED, as it's the only event which let us grab props
      fork_param_substitution(sig->action, props);
      g_print("[MATCH]%s triggered for %s\n",sigflag_to_signame(sig->event_type),settings[i]->nickname);
      exec_action(sig->action);
      //final_fork_handler(settings[i],sig);
    }
  }
  g_print("[added]free prop\n"); 
  g_free(props);
  //device_common_signal_handler(DEV_ADDED, object_path);
}
static void device_removed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  g_print ("removed:   %s\n", object_path);
}

static void device_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  g_print ("changed:     %s\n", object_path);
}

static void device_job_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gboolean    job_in_progress,
					       const char *job_id, guint32     job_initiated_by_uid, gboolean    job_is_cancellable,
					       double      job_percentage, gpointer    user_data) {
  g_print ("job-changed: %s\n", object_path);
  /*if (opt_monitor_detail) {
    print_job (job_in_progress,
    job_id,
    job_initiated_by_uid,
    job_is_cancellable,
    job_percentage);
    }*/
}

static void mount_added (DevkitDisksMountMonitor *monitor, DevkitDisksMount *mount, gpointer user_data) {
  Signal *sig;
  int i;
  const gchar *evtmp = devkit_disks_mount_get_mount_path(mount);
  g_print("[!!]mounted %s\n", evtmp);
  /* TODO
  // if able to grab the property from a simple mount_path
  DeviceProperties *props = device_properties_get(bus,  #SOMETHING#);
  if(DEBUG)
  do_show_info_device_property (props);
  */
  for (i=0; i<MAX_SETTINGS && settings[i]; i++) {
    if((sig = setting_match_on_event(settings[i], DEV_MOUNTED))) {
      // prop_equal_on_mounted(settings[i]->dp,props))
      // TRUE : if no mountpath specified in config, trigger the action anyway
      // to make possible "catchall" Mounted
      if((settings[i]->dp->device_mount_paths) &&
	 !have_common_mount_path2(settings[i]->dp->device_mount_paths, evtmp))
	continue;
      //fstab *plop = getfsfile(evtmp);
      //g_print("dev:%s\n",fstab->fs_spec)
      process_cmd_line_mount_tmp(sig->action->bin, evtmp);
      g_print("[MATCH]%s triggered for %s\n",sigflag_to_signame(sig->event_type),settings[i]->nickname);
      exec_action(sig->action);
      //final_fork_handler(settings[i],sig);
    }
  }
  /*g_print("[added]free prop\n"); 
    g_free(props);*/
}

static void mount_removed (DevkitDisksMountMonitor *monitor, DevkitDisksMount *mount, gpointer user_data) {
  Signal *sig;
  int i;
  const gchar *evtmp = devkit_disks_mount_get_mount_path(mount);
  g_print("[!!]unmounted %s\n", evtmp);
  for (i=0; i<MAX_SETTINGS && settings[i]; i++) {
    if((sig = setting_match_on_event(settings[i], DEV_UNMOUNTED))) {
      if((settings[i]->dp->device_mount_paths) &&
	 !have_common_mount_path2(settings[i]->dp->device_mount_paths, evtmp))
	continue;
      process_cmd_line_mount_tmp(sig->action->bin, evtmp);
      g_print("[MATCH]%s triggered for %s\n",sigflag_to_signame(sig->event_type),settings[i]->nickname);
      exec_action(sig->action);
      // final_fork_handler(settings[i],sig);
    }
  }
}


int main (int argc, char **argv) {
  GError *error = NULL;
  const gchar *filename;
  gchar *fullpath;
  GDir *dir;
  int i = 0;

  GOptionContext      *context;
  static GOptionEntry  entries []     = {
                { "debug", 0, 0, G_OPTION_ARG_NONE, &opt_debug, "Print additional debugging information", NULL },
                { "dump", 0, 0, G_OPTION_ARG_NONE, &opt_dump, "Dump information about settings", NULL },
		{ G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_filenames, "Configuration file", NULL },
		{ NULL }
  };
  setlocale (LC_ALL, "");

  g_type_init ();
  context = g_option_context_new ("FILE|DIR...");
  g_option_context_add_main_entries (context, entries, NULL);
  if (!g_option_context_parse (context, &argc, &argv, &error)) {
    g_print("Can't parse : %s\n",error->message);
    g_error_free(error); error = NULL;
    goto out;
  }
  
  settings = g_new0(Setting *, MAX_SETTINGS);
  catchalls = g_new0(Action *, SIGNAL_COUNT);

  if(opt_debug)
    DEBUG=TRUE;

  if(!opt_filenames) {
    g_print("%s", g_option_context_get_help(context, TRUE, NULL));
    goto out;
  }
  
  while (i < g_strv_length(opt_filenames)) {
    if (g_file_test (opt_filenames[i], G_FILE_TEST_IS_REGULAR))
      settings_init(opt_filenames[i], settings, NULL);
    else if (g_file_test (opt_filenames[i], G_FILE_TEST_IS_DIR)) {
      dir = g_dir_open(opt_filenames[i],0,&error);
      if (error) {
	g_printerr ("g_dir_open(%s) failed - %s\n", opt_filenames[i], error->message);
	g_error_free(error); error = NULL;
	i++;
	continue;
      }
      while((filename = g_dir_read_name(dir)) != NULL) {
	if(DEBUG)
	  g_print("proceed %s\n",filename);
	
	if (g_path_is_absolute (filename))
	  fullpath = g_strdup (filename);
	else
	  fullpath = g_build_filename (opt_filenames[i], filename, NULL);
	
	if (g_file_test (fullpath, G_FILE_TEST_IS_REGULAR)) {
	  //settings_init_old(fullpath,settings);
	  settings_init(fullpath, settings, NULL);
	}
	g_free(fullpath);
      }
      g_dir_close(dir);
    }
    else
      g_error("Cannot stat %s\n",opt_filenames[i]);
    i++;
  }

  if(opt_dump) {
    settings_show_info(settings);
    goto out;
  }

  if (init_dbus())  {
    init_callbacks();
    g_print ("Monitoring activity from the disks daemon. Press Ctrl+C to cancel.\n");
    g_print("main loop\n");
    g_main_loop_run (loop);
  }


 out:
  g_option_context_free(context);
  settings_free(settings);

  if (disks_proxy) {
    if(DEBUG)
      g_print("free proxy\n");
    g_object_unref (disks_proxy);
  }
  if (bus)
    dbus_g_connection_unref (bus);

  exit(0);
}
