#include <stdio.h>
#include <Foundation/Foundation.h>
int main(int argc, char **argv)
{
  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init]; 
  BOOL underscores = [[[NSProcessInfo processInfo] arguments] containsObject:@"-u"];
  BOOL flag = NO;
  int i,j;
  NSDictionary *merged = [NSDictionary dictionaryWithContentsOfFile:@"merged.plist"];
  NSArray *keys = [[merged allKeys] sortedArrayUsingSelector:@selector(compare:)];
  printf("<html><head></head><body>\n");
  for (i = 0; i < [keys count]; i++)
    {
      const char *key = [[keys objectAtIndex:i] cString];
      printf("<a href=\"#%s\">%s</a><br>\n", key, key); 
    }
  for (i = 0; i < [keys count]; i++)
    {
      const char *key = [[keys objectAtIndex:i] cString];
      printf("<h2 id=\"%s\">%s</h2>\n",key, key);
      NSDictionary *foo = [merged objectForKey:[keys objectAtIndex:i]];
      NSDictionary *cMethods = [foo objectForKey:@"ClassMethods"];
      NSDictionary *iMethods= [foo objectForKey:@"InstanceMethods"];
      NSArray *appleI = [[iMethods objectForKey:@"Apple"] sortedArrayUsingSelector:@selector(compare:)];
      NSArray *gsI = [[iMethods objectForKey:@"GNUstep"] sortedArrayUsingSelector:@selector(compare:)];
      NSArray *appleC = [[cMethods objectForKey:@"Apple"] sortedArrayUsingSelector:@selector(compare:)];
      NSArray *gsC = [[cMethods objectForKey:@"GNUstep"] sortedArrayUsingSelector:@selector(compare:)];
      NSArray *bothI = [[iMethods objectForKey:@"Both"] sortedArrayUsingSelector:@selector(compare:)]; 
      NSArray *bothC = [[cMethods objectForKey:@"Both"] sortedArrayUsingSelector:@selector(compare:)]; 
      for (j = 0; j < [appleC count]; j++)
        {
	  if (underscores == [[appleC objectAtIndex:j] hasPrefix:@"_"])
            {
	      if (!flag)
                printf("<dl>\n  <dt>Apple only</dt>\n");
	      flag = YES;
	      printf("    <dd>%s</dd>\n",[[@"+" stringByAppendingString:[appleC objectAtIndex:j]] cString]); 
	    }
	}
      for (j = 0; j < [appleI count]; j++)
        {
	  if (underscores == [[appleI objectAtIndex:j] hasPrefix:@"_"])
	    { 
	      if (!flag)
                printf("<dl>\n  <dt>Apple only</dt>\n");
	      flag = YES;
              printf("    <dd>%s</dd>\n",[[@"-" stringByAppendingString:[appleI objectAtIndex:j]] cString]); 
	    }
	}
      if (flag)
        printf("</dl>\n");
      flag = NO;
      
      for (j = 0; j < [gsC count]; j++)
        {
	  if (underscores == [[gsC objectAtIndex:j] hasPrefix:@"_"])
            {
	      if (!flag)
       		printf("<dl>\n  <dt>GNUstep only</dt>\n");
	      flag = YES;
	      printf("    <dd>%s</dd>\n",[[@"+" stringByAppendingString:[gsC objectAtIndex:j]] cString]); 
	    }
	}
      for (j = 0; j < [gsI count]; j++)
        {
	  if (underscores == [[gsI objectAtIndex:j] hasPrefix:@"_"])
            {
	      if (!flag)
       		printf("<dl>\n  <dt>GNUstep only</dt>\n");
	      flag = YES;
	      printf("    <dd>%s</dd>\n",[[@"-" stringByAppendingString:[gsI objectAtIndex:j]] cString]); 
	    }
	}
      if (flag)
        printf("</dl>\n");
      flag = NO;
      
      for (j = 0; j < [bothC count]; j++)
        {
          if (underscores == [[bothC objectAtIndex:j] hasPrefix:@"_"])
	    {
              if (!flag)
        	printf("<dl>\n  <dt>both</dt>\n");
	      flag = YES;
              printf("    <dd>%s</dd>\n",[[@"+" stringByAppendingString:[bothC objectAtIndex:j]] cString]);
            }
        }
      for (j = 0; j < [bothI count]; j++)
        {
          if (underscores == [[bothI objectAtIndex:j] hasPrefix:@"_"])
	    {
              if (!flag)
        	printf("<dl>\n  <dt>both</dt>\n");
	      flag = YES;
              printf("    <dd>%s</dd>\n",[[@"-" stringByAppendingString:[bothI objectAtIndex:j]] cString]);
            }
        }

      if (flag)
        printf("</dl>\n");
      flag = NO;
    }
    printf("</body></html>\n");
  return 0;
}
