#import <Foundation/Foundation.h>

void do_throw (void);

@interface TestClass : NSObject

- (void) doThrow;

@end

@implementation TestClass

- (void) forwardInvocation: (NSInvocation *) inv
{
  do_throw ();
}

@end

void
do_throw (void)
{
  [NSException raise: NSGenericException format: @"test exception"];
}

int
main (void)
{
  CREATE_AUTORELEASE_POOL (pool);

  @try
    {
// set to 0 to do a direct call of do_throw - that works
#if 1
      TestClass *tc = [TestClass new];

      [tc doThrow];
      DESTROY (tc);
#else
      do_throw ();
#endif
    }
  @catch (NSException *e)
    {
      NSLog (@"caught %@ in main()", e);
    }
  @finally
    {
      NSLog (@"finally in main()");
    }

  DESTROY (pool);

  return 0;
}
