#import <Foundation/Foundation.h>

#include <dlfcn.h>
#include <unwind.h>

void do_throw (void);

static _Unwind_Reason_Code trace(struct _Unwind_Context *context, void *c)
{
    void *ip = (void*)_Unwind_GetIP(context);
    Dl_info info;
    dladdr(ip, &info);
    printf("%p:%s() in %s\n", ip, info.dli_sname, info.dli_fname);
    return _URC_CONTINUE_UNWIND;
}

@interface TestClass : NSObject

- (void) doThrow;

@end

@implementation TestClass

- (void) forwardInvocation: (NSInvocation *) inv
{
  do_throw ();
}

@end

void
do_throw (void)
{
  _Unwind_Backtrace(trace, 0);
//  [NSException raise: NSGenericException format: @"test exception"];
}

int
main (void)
{
  CREATE_AUTORELEASE_POOL (pool);

  @try
    {
// set to 0 to do a direct call of do_throw - that works
#if 1
      TestClass *tc = [TestClass new];

      [tc doThrow];
      DESTROY (tc);
#else
      do_throw ();
#endif
    }
  @catch (NSException *e)
    {
      NSLog (@"caught %@ in main()", e);
    }

  DESTROY (pool);

  return 0;
}
