/*
   Project: TestCuckoo

   Author: patrick

   Created: 2025-12-14 10:14:15 +0100 by patrick
*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <AppKit/NSSound.h>

int main(int argc, const char *argv[]) {
    id pool = [[NSAutoreleasePool alloc] init];

    NSString *soundPath = [[NSBundle mainBundle] pathForResource:@"cuckoo" ofType:@"wav"];
    NSLog(@"Path: %@", soundPath);
    
    NSSound *cuckoo = [[NSSound alloc] initWithContentsOfFile:soundPath byReference:NO];
    [cuckoo retain];

    if (!cuckoo) {
        NSLog(@"Failed to load sound!");
    } else {
        [cuckoo play];
        NSLog(@"Playing sound...");
    } 

    // The end...
    [pool release];

    return 0;
}
