#include <stdio.h>
#include <stdlib.h>

#include "glheader.h"
#include "context.h"
#include "macros.h"

#include "measure.c"

TSC           start, end, mc, nc;

extern void
_mesa_mmx_blend_transparency( void *ctx, GLuint n, const GLubyte mask[],
                              GLchan rgba[][4], const GLchan dest[][4] );

extern void
blend_transparency( void *ctx, GLuint n, const GLubyte mask[],
                              GLchan rgba[][4], const GLchan dest[][4] );

test(
	int n, 
	GLubyte mask[],
	GLchan src[][4],
        GLchan rgba1[][4], 
        GLchan rgba2[][4], 
	GLchan dest[][4])
{
	int m = 1024;
	int i, j, k;

	for(i = 0; i < n; ++i)
	{
		mask[i] = 1;
		for(j = 0; j < 4; ++j)
		{
			src[i][j] = rgba1[i][j] = rgba2[i][j] = rand() & 0xff;
			dest[i][j] = rand() & 0xff;
		}
	}
	
	mask[2] = 0;
	mask[3] = 0;
	
	getTSC(start);
	for(i = 0; i < m; ++i)
	blend_transparency( NULL, n, mask, rgba1, dest );
	getTSC(end);
	nc=TSCdiff(start, end);
		
	getTSC(start);
	for(i = 0; i < m; ++i)
	_mesa_mmx_blend_transparency( NULL, n, mask, rgba2, dest );
	getTSC(end);
	mc=TSCdiff(start, end);

	for(i = 0; i < 16; ++i)
	{
		printf("%i\t", mask[i]);
		for(j = 0; j < 4; ++j)
			printf("%i %i %i\t", rgba1[i][j], rgba2[i][j], src[i][j]);
			
		printf("\n");
	}
	
	PrintResults(mc, nc);
}

int main()
{
	const int n = 64*1024;
	GLubyte *mask = malloc(n);
	GLchan *src = malloc(n*4), *rgba1 = malloc(n*4), *rgba2=malloc(n*4), *dest=malloc(n*4);
	
	test(n, mask, src, rgba1, rgba2, dest);
	
	return 0;
}
