#include "osxdocker.h"
#include "Ecore_X.h"
#ifdef DMALLOC
#include "dmalloc.h"
#endif

static int handle_idle(void * data);
bool need_redraw = false;

int main(int argc, char ** argv)
{
	od_config_init();

	ecore_init();
	ecore_app_args_set(argc, (const char **)argv);
//	ecore_event_handler_add(ECORE_EVENT_SIGNAL_EXIT, callback_exit, NULL);
	ecore_evas_init();

	od_window_init();
	od_dock_init();

	evas_font_path_append(evas, "/usr/share/fonts/ttf-bitstream-vera/");
	od_icon_mapping_add("kmail", "KMail", "kmail");
	od_icon_mapping_add("konqueror", "Konqueror", "konqueror");
	od_icon_mapping_add("MozillaFirebird-bin", "Firebird", "mozilla");
	od_icon_mapping_add("korganizer", "KOrganizer", "korganizer");
	od_icon_mapping_add("XTerm", "Terminal", "konsole");
	od_icon_mapping_add("kate", "Kate", "kate");
	od_icon_mapping_add("Evidence", "Evidence", "kfind");
	od_icon_mapping_add("XClock", "Clock", "clock");
	od_icon_mapping_add("kdesktop", "KDesktop", "desktop");
	od_icon_add_kde_set("/home/genneth/files/Aqua/");
	od_icon_add_kde_set("/usr/kde/3.1/share/icons/crystalsvg/");
	od_icon_add_kde_set("/usr/kde/3.1/share/icons/hicolor/");

	// TODO: some initial applnks and dicons
	od_dock_add_applnk(od_icon_new_applnk("kmail &", "kmail"));
	od_dock_add_applnk(od_icon_new_applnk("kfmclient openProfile webbrowsing &", "konqueror"));
	od_dock_add_applnk(od_icon_new_applnk("MozillaFirebird &", "MozillaFirebird-bin"));
	od_dock_add_applnk(od_icon_new_applnk("korganizer &", "korganizer"));
	od_dock_add_applnk(od_icon_new_applnk("xterm &", "XTerm"));
	od_dock_add_applnk(od_icon_new_applnk("kate &", "kate"));
	od_dock_add_applnk(od_icon_new_applnk("evidence -T nautilus -P icosx ~ &", "Evidence"));
	od_dock_add_dicon(od_icon_new_dicon("kfmclient openProfile filemanagement ~", "Home", "folder_home"));
	od_dock_add_dicon(od_icon_new_dicon("kfmclient openProfile filemanagement Desktop/Trash", "Trash", "trashcan_empty"));
	od_dock_add_dicon(od_icon_new_dicon("xterm -e \"getmail\" &", "Get Mail", "mail_new"));

	od_dock_icons_update_begin();
	ecore_idle_enterer_add(handle_idle, NULL);
	ecore_main_loop_begin();

	fprintf(stderr, "cleanly shutting down\n");
	ecore_evas_shutdown();
	ecore_shutdown();

	return 0;
}

int handle_idle(void * data)
{
	if(need_redraw) {
		od_dock_redraw(NULL);
		evas_render(evas);
		need_redraw = false;
	}
	return 0;
}
