#include "osxdocker.h"
#include <Ecore_X.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#ifdef DMALLOC
#include "dmalloc.h"
#endif

Ecore_Evas * ee;
Evas * evas;
Ecore_X_Window od_window;

static void handle_mouse_out(Ecore_Evas * _ee);
static void handle_mouse_down(void * data, Evas * e, Evas_Object * obj, void * event);
static void handle_mouse_move(void * data, Evas * e, Evas_Object * obj, void * event);

void od_window_init()
{
	// determine the desktop size
#if 0
	double res_x, res_y;
	{
		int w, h;
		ecore_x_window_size_get(0, &w, &h);
		res_x = w;
		res_y = h;
	}
#else
	double res_x = 1024, res_y = 768;
#endif

	ee = ecore_evas_software_x11_new(NULL, 0,
		(int)((res_x - options.width) / 2.0), (int)(res_y - options.height),
		options.width, options.height);
	ecore_evas_title_set(ee, "OSXDocker");
	ecore_evas_name_class_set(ee, "osxdocker", "osxdocker");
	ecore_evas_borderless_set(ee, 1);
	ecore_evas_size_min_set(ee, options.width, options.height);
	ecore_evas_size_max_set(ee, options.width, options.height);
	ecore_evas_callback_pre_render_set(ee, od_dock_redraw);
	ecore_evas_callback_focus_out_set(ee, handle_mouse_out);
//	ecore_evas_callback_mouse_out_set(ee, handle_mouse_down);

	evas = ecore_evas_get(ee);
	Evas_Object * eventer = evas_object_rectangle_add(evas);
	evas_object_color_set(eventer, 0, 0, 0, 0);
	evas_object_resize(eventer, options.width, options.height);
	evas_object_move(eventer, 0.0, 0.0);
	evas_object_layer_set(eventer, 9999);
	evas_object_show(eventer);
	evas_object_event_callback_add(eventer, EVAS_CALLBACK_MOUSE_DOWN, handle_mouse_down, NULL);
	evas_object_event_callback_add(eventer, EVAS_CALLBACK_MOUSE_MOVE, handle_mouse_move, NULL);

	od_window = ecore_evas_software_x11_window_get(ee);
	#if 0
	{
		XSizeHints hints;
		long ret;
		memset(&hints, 0, sizeof(XSizeHints));
		XGetWMNormalHints(ecore_x_display_get(), od_window, &hints, &ret);
		hints.flags |= PPosition | USPosition | PSize | USSize;
		hints.x = (int)((res_x - options.width) / 2.0);
		hints.y = (int)(res_y - options.height);
		XSetWMNormalHints(ecore_x_display_get(), od_window, &hints);
	}
	#else
	ecore_x_window_prop_xy_set(od_window,
		(int)((res_x - options.width) / 2.0), (int)(res_y - options.height));
	#endif
	ecore_x_window_prop_window_type_dock_set(od_window);
	ecore_x_window_prop_sticky_set(od_window, 1);
	ecore_x_window_prop_desktop_request(od_window, 4294967295L);

	ecore_evas_show(ee);

	XImage * rootimage = XGetImage(ecore_x_display_get(), DefaultRootWindow(ecore_x_display_get()), 0, 0,
		(int)res_x, (int)res_y,
		0xffffffff, ZPixmap);
	if(rootimage) {
		int * buffer = (int *)malloc(sizeof(int) * (int)res_x * (int)res_y);
		int x, y;
		int * pos = buffer;
		for(y = 0; y < (int)res_y; y++) {
			for(x = 0; x < (int)res_x; x++) {
				int pixel = XGetPixel(rootimage, x, y);
				*pos = pixel;
				pos++;
			}
		}
		Evas_Object * background = evas_object_image_add(evas);
		evas_object_image_size_set(background, (int)res_x, (int)res_y);
		evas_object_image_data_copy_set(background, buffer);
		free(buffer);
		evas_object_image_data_update_add(background, 0, 0, (int)res_x, (int)res_y);
		evas_object_image_fill_set(background, 0.0, 0.0, res_x, res_y);
		evas_object_image_alpha_set(background, 0);
		evas_object_resize(background, res_x, res_y);
		evas_object_move(background, (options.width - res_x) / 2.0, options.height - res_y);
		evas_object_layer_set(background, -9999);
		evas_object_show(background);

	} else {
	}

}

static void handle_mouse_out(Ecore_Evas * _ee)
{
	if(_ee != ee) return;
	if(dock.state == zooming || dock.state == zoomed)
		od_dock_zoom_out();
}

static void handle_mouse_down(void * data, Evas * e, Evas_Object * obj, void * event)
{
	Evas_Event_Mouse_Down * ev = (Evas_Event_Mouse_Down *)event;
	OD_Icon * icon = NULL;
	{
		Evas_List * objects = evas_objects_at_xy_get(evas, ev->canvas.x, ev->canvas.y, 0, 0);
		Evas_List * item = objects;
		bool done = false;
		while(item && !done) {
			const char * name = evas_object_name_get((Evas_Object *)item->data);
			if(name && strncmp("icon", name, 4) == 0) {
				Evas_List * i2 = dock.icons;
				while(i2 && !done) {
					if(((OD_Icon *)(i2->data))->icon == (Evas_Object *)item->data) {
						icon = (OD_Icon *)i2->data;
						done = true;
					}
					i2 = i2->next;
				}
			}
			item = item->next;
		}
	}
	if(!icon || !(icon->state & OD_ICON_STATE_USEABLE)) return;

	if(icon->type == application_link) {
		if((icon->data.applnk.count == 0 && ev->button == 1) || ev->button == 2) {
			// then make one...
			system(icon->data.applnk.command);
		} else if(icon->data.applnk.count > 0 && ev->button == 1) {
			Evas_List * item = clients;
			while(item) {
				OD_Window * window = (OD_Window *)item->data;
				if(window->applnk == icon)
					od_wm_activate_window(window->id);
				item = evas_list_next(item);
			}
		}
	} else if(icon->type == docked_icon) {
		if(ev->button == 1) {
			system(icon->data.dicon.command);
		}
	} else if(icon->type == minimised_window) {
		if(ev->button == 1) {
			od_wm_activate_window(icon->data.minwin.window);
		}
	}

}

static void handle_mouse_move(void * data, Evas * e, Evas_Object * obj, void * event)
{
	Evas_Event_Mouse_Move * ev = (Evas_Event_Mouse_Move *)event;
	if(ev->cur.canvas.y >= (options.height - options.arrow_size - options.size * dock.zoom) &&
		ev->cur.canvas.y <= options.height && ev->cur.canvas.x > dock.left_end &&
		ev->cur.canvas.x < dock.right_end) {
		dock.x = ev->cur.canvas.x;
		if(dock.state == unzoomed || dock.state == unzooming) od_dock_zoom_in();
		need_redraw = true;
	} else if(dock.state == zoomed || dock.state == zooming) od_dock_zoom_out();
}

