#ifndef _PIXEL_OP_H
#define _PIXEL_OP_H

#define MUL4_256(a, r, g, b, c) \
 ( (((((c) >> 8) & 0xff0000) * (a)) & 0xff000000) + \
   (((((c) & 0xff0000) * (r)) >> 8) & 0xff0000) + \
   (((((c) & 0xff00) * (g)) >> 8) & 0xff00) + \
   ((((c) & 0xff) * (b)) >> 8) )

#define MUL3_256(r, g, b, c) \
 ( (((((c) & 0xff0000) * (r)) >> 8) & 0xff0000) + \
   (((((c) & 0xff00) * (g)) >> 8) & 0xff00) + \
   ((((c) & 0xff) * (b)) >> 8) )

#define MUL_256(a, c) \
 ( (((((c) >> 8) & 0x00ff00ff) * (a)) & 0xff00ff00) + \
   (((((c) & 0x00ff00ff) * (a)) >> 8) & 0x00ff00ff) )

#define MUL4_SYM(x, y) \
 ( ((((((x) >> 16) & 0xff00) * (((y) >> 16) & 0xff00)) + 0xff00) & 0xff000000) + \
   ((((((x) >> 8) & 0xff00) * (((y) >> 8) & 0xff00)) + 0xff00) & 0xff0000) + \
   (((((x) & 0xff00) * ((y) & 0xff00) + 0xff00) >> 8) & 0xff00) + \
   ((((x) & 0xff) * ((y) & 0xff) + 0xff) >> 8) )

#define MUL3_SYM(x, y) \
 ( ((((((x) >> 8) & 0xff00) * (((y) >> 8) & 0xff00)) + 0xff00) & 0xff0000) + \
   (((((x) & 0xff00) * ((y) & 0xff00) + 0xff00) >> 8) & 0xff00) + \
   ((((x) & 0xff) * ((y) & 0xff) + 0xff) >> 8) )

#define MUL_SYM(a, x) \
 ( (((((x) >> 8) & 0x00ff00ff) * (a) + 0xff00ff) & 0xff00ff00) + \
   (((((x) & 0x00ff00ff) * (a) + 0xff00ff) >> 8) & 0x00ff00ff) )

#define INTERP_256(a, c0, c1) \
 ( (((((((c0) >> 8) & 0xff00ff) - (((c1) >> 8) & 0xff00ff)) * (a)) \
   + ((c1) & 0xff00ff00)) & 0xff00ff00) + \
   (((((((c0) & 0xff00ff) - ((c1) & 0xff00ff)) * (a)) >> 8) \
   + ((c1) & 0xff00ff)) & 0xff00ff) )

#define ARGB_JOIN(a, r, g, b)  \
	(((a) << 24) + ((r) << 16) + ((g) << 8) + (b))
#define RGB_JOIN(r, g, b)  \
	(((r) << 16) + ((g) << 8) + (b))

#ifndef DATA32
typedef unsigned long long  DATA64;
typedef unsigned int        DATA32;
typedef unsigned short      DATA16;
typedef unsigned char       DATA8;
#endif

typedef struct _Pixel_Op_Params Pixel_Op_Params;
typedef void (*Pixel_Op_Func) (Pixel_Op_Params *params);

#define PIXEL_OP_VERSION 1

typedef enum _Pixel_Op
{
   PIXEL_OP_COPY,
   PIXEL_OP_BLEND,
   PIXEL_OP_ADD,
   PIXEL_OP_SUB,
   PIXEL_OP_LAST
} Pixel_Op;

struct _Pixel_Op_Params
{
   DATA32   v;  /* pixel op parameter version - 1 to start */
   DATA32   l;  /* run length in pixels - always > 0 */
   Pixel_Op op; /* one of the supported ops in Pixel_Op */
   struct {
      DATA32 *p; /* color and alpha pixel pointer - NULL       == not used */
      DATA8  *m; /* alpha mask pixel pointer      - NULL       == not used */
      DATA32  c; /* color multiplier              - 0xffffffff == not used */
      DATA8   alpha  : 1; /* pixels contain alpha */
      DATA8   sparse : 1; /* pixels have sparse alpha (mostly 0, or 255) */
   } src, dst;
   /* -- */
   /* expanded parameters go here in future - if we expand we need to go up */
   /* a version number so we know if the request was old or new style */
   /* -- */
};

int           pixel_op_init(void);
int           pixel_op_shutdown(void);
inline void   pixel_op_params_init(Pixel_Op_Params *params, DATA32 v);
#define       PO_INIT(pp) pixel_op_params_init(pp, PIXEL_OP_VERSION);
Pixel_Op_Func pixel_op_get(Pixel_Op_Params *params, int cpumode);
void          pixel_op(Pixel_Op_Params *params);
void          pixel_op_end(void);
    
#endif
