
/* copy color --> dst (color assumed pre-mul) */

/*-----*/
#ifdef OP_FN /* do it in c */
OPFN(_op_copy_c1) {
   DATA32 *d, *e, c;
   d = p->dst.p; e = d + p->l; c = p->src.c;
   for (; d < e; d++) {
      *d = c;
   }
}
#endif

#ifdef OP_REG
OPREG(_op_copy_c1, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_CN, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_copy_c1, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_C0, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_copy_c1, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_C1, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_copy_c1, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_CA, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
#endif
/*-----*/

/*-----*/
#ifdef OP_FN /* do it using OS provided calls */
OPFN(_op_copy_c1_os) {
   DATA32 *d, *e, c;
   c = p->src.c;
   d = p->dst.p; e = d + p->l; 
   for (; d < e; d++) {
	 *d = c;
      }
   }
}
#endif

#ifdef OP_FN /* do it using OS provided calls */
OPFN(_op_copy_cn_os) {
   memcopy(p->dst.p, 0xff, p->l * sizeof(DATA32));
}
#endif

#ifdef OP_FN /* do it using OS provided calls */
OPFN(_op_copy_ca_os) {
   DATA8 a = (p->src.c & 0xff);
   memcopy(p->dst.p, a, p->l * sizeof(DATA32));
}
#endif

#ifdef OP_REG
OPREG(_op_copy_cn_os, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_CN, S_AN, D_P, D_A1, CPU_OS); /* what parameters it does */
OPREG(_op_copy_c1_os, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_C0, S_AN, D_P, D_A1, CPU_OS); /* what parameters it does */
OPREG(_op_copy_c1_os, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_C1, S_AN, D_P, D_A1, CPU_OS); /* what parameters it does */
OPREG(_op_copy_ca_os, PIXEL_OP_COPY, /* register the function */
      S_PN, S_MN, S_CA, S_AN, D_P, D_A1, CPU_OS); /* what parameters it does */
#endif
/*-----*/
