
/* copy mask x color -> dst  (color assumed pre-mul) */

/*-----*/
#ifdef OP_FN /* do it in c */
OPFN(_op_cp_m1_c1) {
   DATA32 *d, *e, c;
   DATA8  *m;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = c;
		break;
	    default:
		a++;
		*d = MUL_256(a, c);
		break;
	  }
	m++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_m1_c0) {
   DATA32 *d, *e, c;
   DATA8  *m;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = c;
		break;
	    default:
		*d = (a << 24) | (c & 0x00ffffff);
		break;
	  }
	m++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_m1_cn) {
   DATA32 *d, *e;
   DATA8  *m;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = 0xffffffff;
		break;
	    default:
		*d = (a << 24) | 0x00ffffff;
		break;
	  }
	m++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_m1_ca) {
   DATA32 *d, *e, c;
   DATA8  *m;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = c;
		break;
	    default:
		a = ((a * (c & 0xff)) + 0xff) >> 8;
		*d = ARGB_JOIN(a, a, a, a);
		break;
	  }
	m++;  d++;
     }
}
#endif

#ifdef OP_REG
OPREG(_op_cp_m1_c1, PIXEL_OP_COPY, /* register the function */
      S_PN, S_M1, S_C1, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_m1_c0, PIXEL_OP_COPY, /* register the function */
      S_PN, S_M1, S_C0, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_m1_cn, PIXEL_OP_COPY, /* register the function */
      S_PN, S_M1, S_CN, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_m1_ca, PIXEL_OP_COPY, /* register the function */
      S_PN, S_M1, S_CA, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
#endif
/*-----*/
