
/* copy pixel x color --> dst  (color assumed pre-mul) */

/*-----*/
#ifdef OP_FN /* do it in c */
OPFN(_op_cp_p1_c1) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = p->src.c;

   while (d < e)
     {
	*d = MUL4_SYM(c, *s);
	s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pas_c1) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = A_VAL(s);

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = (c & 0xff000000) + MUL3_SYM(c, *s);
		break;
	    default:
		*d = MUL4_SYM(c, *s);
		break;
	  }
	s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pan_c1) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = p->src.c;

   while (d < e)
     {
	*d = (c & 0xff000000) + MUL3_SYM(c, *s);
	s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_p1_c0) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = p->src.c;

   while (d < e)
     {
	*d = (*s & 0xff000000) + MUL3_SYM(c, *s);
	s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pas_c0) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = A_VAL(s);

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = 0xff000000 + MUL3_SYM(c, *s);
		break;
	    default:
		*d = (a << 24) + MUL3_SYM(c, *s);
		break;
	  }
	s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pan_c0) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = p->src.c;

   while (d < e)
     {
	*d = 0xff000000 + MUL3_SYM(c, *s);
	s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_p1_ca) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = 1 + ((p->src.c) & 0xff);

   while (d < e)
     {
	*d = MUL_256(c, *s);
	s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pan_ca) {
   DATA32 *s, *d, *e, c;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   c = 1 + ((p->src.c) & 0xff);

   while (d < e)
     {
	*d = MUL_256(c, *s | 0xff000000);
	s++;  d++;
     }
}
#endif

#define _op_cp_pas_ca _op_cp_p1_ca

#ifdef OP_REG
OPREG(_op_cp_p1_c1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_C1, S_A1, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pas_c1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_C1, S_AS, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pan_c1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_C1, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_p1_c0, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_C0, S_A1, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pas_c0, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_C0, S_AS, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pan_c0, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_C0, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_p1_ca, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_CA, S_A1, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pas_ca, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_CA, S_AS, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pan_ca, PIXEL_OP_COPY, /* register the function */
      S_P1, S_MN, S_CA, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
#endif
/*-----*/

