
/* copy pixel x mask --> dst */

/*-----*/
#ifdef OP_FN /* do it in c */
OPFN(_op_cp_p1_m1) {
   DATA32 *s, *d, *e;
   DATA8  *m;
   d = p->dst.p; e = d + p->l;
   s = p->src.p;
   m = p->src.m;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = *s;
		break;
	    default:
		a++;
		*d = MUL_256(a, *s);
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pas_m1) {
   DATA32 *s, *d, *e;
   DATA8  *m;
   d = p->dst.p; e = d + p->l;
   s = p->src.p;
   m = p->src.m;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = *s;
		break;
	    default:
		switch(A_VAL(s))
		  {
		    case 0:
			*d = 0;
			break;
		    default:
			a++;
			*d = MUL_256(a, *s);
			break;
		  }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pan_m1) {
   DATA32 *s, *d, *e;
   DATA8  *m;
   d = p->dst.p; e = d + p->l;
   s = p->src.p;
   m = p->src.m;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = (*s | 0xff000000);
		break;
	    default:
		a++;
		*d = MUL_256(a, *s | 0xff000000);
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_REG
OPREG(_op_cp_p1_m1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_CN, S_A1, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pas_m1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_CN, S_AS, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pan_m1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_CN, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
#endif
/*-----*/
