
/* copy pixel x mask x color --> dst  (color assumed pre-mul) */

/*-----*/
#ifdef OP_FN /* do it in c */
OPFN(_op_cp_p1_m1_c1) {
   DATA32 *s, *d, *e, c;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = MUL4_SYM(c, *s);
		break;
	    default:
	      {
		DATA32 cs = MUL4_SYM(c, *s);

		a++;
		*d = MUL_256(a, cs);
	      }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pas_m1_c1) {
   DATA32 *s, *d, *e, c;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
	      {
		DATA32 sa = A_VAL(s);

		switch(sa)
		  {
		    case 0:
			*d = 0;
			break;
		    case 255:
			*d = (c & 0xff000000) + MUL3_SYM(c, *s);
			break;
		    default:
			*d = MUL4_SYM(c, *s);
			break;
		  }
	      }
		break;
	    default:
	      {
		DATA32 sa = A_VAL(s);

		switch(sa)
		  {
		    case 0:
			*d = 0;
			break;
		    case 255:
			sa = (c & 0xff000000) + MUL3_SYM(c, *s);
			a++;
			*d = MUL_256(a, sa);
			break;
		    default:
			sa = MUL4_SYM(c, *s);
			a++;
			*d = MUL_256(a, sa);
			break;
		  }
	      }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pan_m1_c1) {
   DATA32 *s, *d, *e, c;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = (c & 0xff000000) + MUL3_SYM(c, *s);
		break;
	    default:
	      {
		DATA32 cs = (c & 0xff000000) + MUL3_SYM(c, *s);

		a++;
		*d = MUL_256(a, cs);
	      }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_p1_m1_c0) {
   DATA32 *s, *d, *e, c;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = (*s & 0xff000000) + MUL3_SYM(c, *s);
		break;
	    default:
	      {
		DATA32 cs = (*s & 0xff000000) + MUL3_SYM(c, *s);

		a++;
		*d = MUL_256(a, cs);
	      }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pas_m1_c0) {
   DATA32 *s, *d, *e, c;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
	      {
		DATA32 sa = A_VAL(s);

		switch(sa)
		  {
		    case 0:
			*d = 0;
			break;
		    case 255:
			*d = 0xff000000 + MUL3_SYM(c, *s);
			break;
		    default:
			*d = (*s & 0xff000000) + MUL3_SYM(c, *s);
			break;
		  }
	      }
		break;
	    default:
	      {
		DATA32 sa = A_VAL(s);

		switch(sa)
		  {
		    case 0:
			*d = 0;
			break;
		    case 255:
			sa = 0xff000000 + MUL3_SYM(c, *s);
			a++;
			*d = MUL_256(a, sa);
			break;
		    default:
			sa = (*s & 0xff000000) + MUL3_SYM(c, *s);
			a++;
			*d = MUL_256(a, sa);
			break;
		  }
	      }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pan_m1_c0) {
   DATA32 *s, *d, *e, c;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = 0xff000000 + MUL3_SYM(c, *s);
		break;
	    default:
	      {
		DATA32 cs = 0xff000000 + MUL3_SYM(c, *s);

		a++;
		*d = MUL_256(a, cs);
	      }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_p1_m1_ca) {
   DATA32 *s, *d, *e, c, ca;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;
   ca = 1 + (c & 0xff);

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = MUL_256(ca, *s);
		break;
	    default:
		a = 1 + ((ca * a) >> 8);
		*d = MUL_256(a, *s);
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pas_m1_ca) {
   DATA32 *s, *d, *e, c, ca;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;
   ca = 1 + (c & 0xff);

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		switch(A_VAL(s))
		  {
		    case 0:
			*d = 0;
			break;
		    default:
			*d = MUL_256(ca, *s);
			break;
		  }
		break;
	    default:
		switch(A_VAL(s))
		  {
		    case 0:
			*d = 0;
			break;
		    default:
			a = 1 + ((ca * a) >> 8);
			*d = MUL_256(a, *s);
			break;
		  }
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_FN /* do it in c */
OPFN(_op_cp_pan_m1_ca) {
   DATA32 *s, *d, *e, c, ca;
   DATA8  *m;
   s = p->src.p;
   d = p->dst.p; e = d + p->l;
   m = p->src.m;
   c = p->src.c;
   ca = 1 + (c & 0xff);

   while (d < e)
     {
	DATA32 a = *m;

	switch(a)
	  {
	    case 0:
		*d = 0;
		break;
	    case 255:
		*d = MUL_256(ca, *s | 0xff000000);
		break;
	    default:
		a = 1 + ((ca * a) >> 8);
		*d = MUL_256(a, *s | 0xff000000);
		break;
	  }
	m++;  s++;  d++;
     }
}
#endif

#ifdef OP_REG
OPREG(_op_cp_p1_m1_c1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_C1, S_A1, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pas_m1_c1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_C1, S_AS, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pan_m1_c1, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_C1, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_p1_m1_c0, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_C0, S_A1, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pas_m1_c0, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_C0, S_AS, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pan_m1_c0, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_C0, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_p1_m1_ca, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_CA, S_A1, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pas_m1_ca, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_CA, S_AS, D_P, D_A1, CPU_C); /* what parameters it does */
OPREG(_op_cp_pan_m1_ca, PIXEL_OP_COPY, /* register the function */
      S_P1, S_M1, S_CA, S_AN, D_P, D_A1, CPU_C); /* what parameters it does */
#endif
/*-----*/

