#include "filehandle.h"

Eina_Bool filehandle_newconnection(void *data, int type, Ecore_Con_Event_Client_Add *ev)
{

	printf("Client with ip %s connected! instance = %p\n", ecore_con_client_ip_get(ev->client), ev->client);
	return(ECORE_CALLBACK_RENEW);
}

Eina_Bool filehandle_lostconnection(void *data, int type, Ecore_Con_Event_Client_Del *ev)
{
	//ecore_main_loop_quit();
	ecore_con_client_del(ev->client);
	return(ECORE_CALLBACK_RENEW);
}

Eina_Bool filehandle_gotdata(void *data, int type, Ecore_Con_Event_Client_Data *ev)
{
	char fmt[128];

	snprintf(fmt, sizeof(fmt), "Received %i bytes from client:\n>>>>>\n%%.%is\n>>>>>\n", ev->size, ev->size);

	printf(fmt, ev->data);
   
	Eina_List *list,
	          *l;
	Ecore_Con_Client *clientinfo;
	
	list = ecore_con_server_clients_get(serverid);
	EINA_LIST_FOREACH(list, l, clientinfo)
	{
		if( clientinfo != ev->client )
		{
			ecore_con_client_send (clientinfo, ev->data, ev->size);
			ecore_con_server_flush (serverid);
		}
	}
   
	return(ECORE_CALLBACK_RENEW);
}
