#include <stdio.h>
#include <Ecore.h>
#include <Ecore_Con.h>

Ecore_Con_Server *serverid;

Eina_Bool filehandle_newconnection(void *data, int type, Ecore_Con_Event_Client_Add *ev);
Eina_Bool filehandle_lostconnection(void *data, int type, Ecore_Con_Event_Client_Del *ev);
Eina_Bool filehandle_gotdata(void *data, int type, Ecore_Con_Event_Client_Data *ev);


int main()
{
	eina_init();
	ecore_init();
	ecore_con_init();

	serverid = ecore_con_server_add(ECORE_CON_REMOTE_TCP, "127.0.0.1", 8080, NULL);

	if ( !serverid )
		exit(1);

	ecore_event_handler_add(ECORE_CON_EVENT_CLIENT_ADD, (Ecore_Event_Handler_Cb)filehandle_newconnection, NULL);
	ecore_event_handler_add(ECORE_CON_EVENT_CLIENT_DEL, (Ecore_Event_Handler_Cb)filehandle_lostconnection, NULL);
	ecore_event_handler_add(ECORE_CON_EVENT_CLIENT_DATA, (Ecore_Event_Handler_Cb)filehandle_gotdata, NULL);

	ecore_main_loop_begin();
   
	return(0);
}


Eina_Bool filehandle_newconnection(void *data, int type, Ecore_Con_Event_Client_Add *ev)
{

	return(ECORE_CALLBACK_RENEW);
}

Eina_Bool filehandle_lostconnection(void *data, int type, Ecore_Con_Event_Client_Del *ev)
{
	ecore_con_client_del(ev->client);
	return(ECORE_CALLBACK_RENEW);
}

Eina_Bool filehandle_gotdata(void *data, int type, Ecore_Con_Event_Client_Data *ev)
{
	Eina_List *list,
	          *l;
	Ecore_Con_Client *clientinfo;
	
	list = ecore_con_server_clients_get(serverid);
	EINA_LIST_FOREACH(list, l, clientinfo)
	{
		if( clientinfo != ev->client )
		{
			ecore_con_client_send (clientinfo, ev->data, ev->size);
			ecore_con_server_flush (serverid);
		}
	}
   
	return(ECORE_CALLBACK_RENEW);
}
