#!/usr/bin/env python

#  Copyright (C) 2005 Björn Grüning
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  $Id: menu-extra.py


import gtk

_ui_str = """
<ui>
	<menubar name="menubar">
		<menu name="ViewMenu" action="View">
			<menuitem name="ViewAllReload"
				action="ViewAllReload"/>
		</menu>
	</menubar>
</ui>
"""

def _reload_all_tabs_cb(action, window):
	tabs = window.get_tabs()
	for i in range(len(tabs)):
		tabs[i].get_embed().reload(True)

	

_actions = [('ViewAllReload', gtk.STOCK_REFRESH, '_Reload All Tabs', '<control>Y', 'Reload All Open Tabs', _reload_all_tabs_cb)]

def attach_window(window):
	ui_manager = window.get_ui_manager()
	group = gtk.ActionGroup('WindowActions')
	group.add_actions(_actions, window)
	ui_manager.insert_action_group(group, 0)
	ui_id = ui_manager.add_ui_from_string(_ui_str)

	window._view_all_tabs_window_data = (group, ui_id)

def detach_window(window):
	group, ui_id = window._view_all_tabs_window_data
	del window._view_all_tabs_window_data

	ui_manager = window.get_ui_manager()
	ui_manager.remove_ui(ui_id)
	ui_manager.remove_action_group(group)
	ui_manager.ensure_update()
