/*
 *  Copyright (C) 2006 Martin Schoen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: ephy-rss-reader-extension.h,v 1.2 2004/12/30 22:42:23 chpe Exp $
 */

#include "config.h"

#ifndef EPHY_RSS_READER_EXTENSION_H
#define EPHY_RSS_READER_EXTENSION_H

#include <glib.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h> /* see Translation */

#include <gmodule.h>

#include <epiphany/ephy-extension.h>

G_BEGIN_DECLS

#define EPHY_TYPE_RSS_READER_EXTENSION		(ephy_rss_reader_extension_get_type ())
#define EPHY_RSS_READER_EXTENSION(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), EPHY_TYPE_RSS_READER_EXTENSION, EphyRssReaderExtension))
#define EPHY_RSS_READER_EXTENSION_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), EPHY_TYPE_RSS_READER_EXTENSION, EphyRssReaderExtensionClass))
#define EPHY_IS_RSS_READER_EXTENSION(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), EPHY_TYPE_RSS_READER_EXTENSION))
#define EPHY_IS_RSS_READER_EXTENSION_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), EPHY_TYPE_RSS_READER_EXTENSION))
#define EPHY_RSS_READER_EXTENSION_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), EPHY_TYPE_RSS_READER_EXTENSION, EphyRssReaderExtensionClass))

typedef struct _EphyRssReaderExtension		EphyRssReaderExtension;
typedef struct _EphyRssReaderExtensionClass	EphyRssReaderExtensionClass;
typedef struct _EphyRssReaderExtensionPrivate	EphyRssReaderExtensionPrivate;

struct _EphyRssReaderExtensionClass
{
	GObjectClass parent_class;
};

struct _EphyRssReaderExtension
{
	GObject parent_instance;

	/*< private >*/
	EphyRssReaderExtensionPrivate *priv;
};

GType	ephy_rss_reader_extension_get_type		(void);

GType	ephy_rss_reader_extension_register_type	(GTypeModule *module);

G_END_DECLS

#endif
