/*
 *  Copyright (C) 2006 Martin Schoen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef FEED_MANAGER_H
#define FEED_MANAGER_H

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include <epiphany/ephy-tab.h>
#include "ephy-debug.h"

G_BEGIN_DECLS

#define TYPE_FEED_MANAGER						(feed_manager_get_type ())
#define FEED_MANAGER(obj)								(G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FEED_MANAGER, FeedManager))
#define FEED_MANAGER_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FEED_MANAGER, FeedManagerClass))
#define IS_FEED_MANAGER(obj)						(G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FEED_MANAGER))
#define IS_FEED_MANAGER_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FEED_MANAGER))
#define FEED_MANAGER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FEED_MANAGER, FeedManagerClass))

typedef struct _FeedManagerPrivate	FeedManagerPrivate;

typedef struct
{
	GObject parent_instance;

	/*< private >*/
	FeedManagerPrivate *priv;
} FeedManager;

typedef struct 
{
	GObjectClass parent_class;
	
	/* Signals */
	void (*feed_loaded)(guint position);
	void (*feeds_updated)(gpointer tab, gchar *file);
} FeedManagerClass;

GType		 feed_manager_get_type		(void);
GType		 feed_manager_register_type	(GTypeModule *module);

void feed_manager_add_feed (FeedManager *self, const gchar *uri);
void feed_manager_refresh (FeedManager *self, EphyTab *tab);

G_END_DECLS

#endif
