/*
 *  Copyright (C) 2006 Martin Schoen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PAGE_BUILDER_H
#define PAGE_BUILDER_H

#define _GNU_SOURCE
#include <time.h>

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include <libxml/tree.h>

#include "feed.h"

G_BEGIN_DECLS

#define TYPE_PAGE_BUILDER		(page_builder_get_type ())
#define PAGE_BUILDER(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), TYPE_PAGE_BUILDER, PageBuilder))
#define PAGE_BUILDER_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST((k), TYPE_PAGE_BUILDER, PageBuilderClass))
#define IS_PAGE_BUILDER(o)	(G_TYPE_CHECK_INSTANCE_TYPE ((o), TYPE_PAGE_BUILDER))
#define IS_PAGE_BUILDER_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), TYPE_PAGE_BUILDER))
#define PAGE_BUILDER_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), TYPE_PAGE_BUILDER, PageBuilderClass))

typedef struct _PageBuilderPrivate PageBuilderPrivate;

typedef struct 
{
	GObject parent_instance;

	/*< private >*/
	PageBuilderPrivate *priv;
} PageBuilder;

typedef struct 
{
	GObjectClass parent_class;
} PageBuilderClass;

GType		 page_builder_get_type		(void);

GType		 page_builder_register_type	(GTypeModule *module);

xmlDocPtr page_builder_process_feed (PageBuilder *self, xmlDocPtr feed, const time_t last_update);
xmlDocPtr page_builder_create_page (PageBuilder *self, const GList *feeds);

G_END_DECLS

#endif
