<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output
  method = "xml"
  version = "1.0"
  encoding = "utf-8"
  omit-xml-declaration = "yes"
  indent = "yes"/>

<!--
		this file generates the menu on the left side of the page
		
		v0.3
-->

<xsl:param name="rss-icon">/usr/share/epiphany-extensions/rss-icon.png</xsl:param>
<xsl:param name="show-all">All</xsl:param>
<xsl:param name="show-old">show old Items</xsl:param>

<xsl:template match="/">
	<div id="menu">
			<img src="{$rss-icon}" />
			<a href="#" onClick="show_all()">
				<xsl:value-of select="$show-all"/>
				<span class="number_entries">
					(<xsl:value-of select="count(/div/div/div[@class='entry'])"/>/<xsl:value-of select="count(/div/div/div[@class='entry'])+count(/div/div/div[@class='entry_hidden'])"/>)
				</span>
			</a>	
			<xsl:apply-templates/>
			<div><input type="checkbox" onChange="show_old_entries()"/>
				<xsl:value-of select="$show-old"/>
			</div>
	</div>
</xsl:template>

<xsl:template match="div[@class='feed']">
	<a href="#{./@id}" onClick="show_feed('{./@id}')">
		<!-- <img src="{div[@class='icon']/@src}" class="menuicon" /> -->
		<xsl:value-of select="div[@class='feedtitle']"/>
		<span class="number_entries">
			(<xsl:value-of select="count(div[@class='entry'])"/>/<xsl:value-of select="count(div[@class='entry'])+count(div[@class='entry_hidden'])"/>)
		</span>
	</a>
</xsl:template>

</xsl:stylesheet>
