/*
 *  Copyright (C) 2006 Martin Schoen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef FEED_H
#define FEED_H

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

G_BEGIN_DECLS

#define TYPE_FEED							(feed_get_type ())
#define FEED(obj)								(G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FEED, Feed))
#define FEED_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FEED, FeedClass))
#define IS_FEED(obj)						(G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FEED))
#define IS_FEED_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FEED))
#define FEED_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FEED, FeedClass))

typedef struct _FeedPrivate	FeedPrivate;

typedef struct
{
	GObject parent_instance;
	FeedPrivate *priv;
} Feed;

typedef struct 
{
	GObjectClass parent_class;
	
	/** Signals */
	void (*feed_loaded)(Feed *self);
} FeedClass;

GType feed_get_type (void);
GType feed_register_type (GTypeModule *module);

void feed_add_to_bookmarks (Feed *self);
gboolean feed_is_in_bookmarks (Feed *self);
void feed_refresh (Feed *self);

G_END_DECLS

#endif
