<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output
  method = "xml"
  version = "1.0"
  encoding = "utf-8"
  omit-xml-declaration = "yes"
  indent = "yes"/>

<!--
		this file transforms an rss file to a html page for display
		
		currently supports RSS 2.0 and Atom 1.0
		
		v0.3
-->

<xsl:param name="feed-title"></xsl:param>

<xsl:template match="/|*[local-name()='RDF']|*[local-name()='rss']">
	<xsl:apply-templates select="*[local-name()='RDF']|*[local-name()='rss']|*[local-name()='channel']|*[local-name()='feed']"/>
</xsl:template>

<xsl:template match="*[local-name()='channel']|*[local-name()='feed']">
	<div class="feed" id="{translate(*[local-name()='title'], ' ', '')}">
		<xsl:if test="boolean(*[local-name()='image'])">
			<xsl:apply-templates select="*[local-name()='image']"/>
		</xsl:if>
		<xsl:if test="boolean(*[local-name()='icon'])">
			<img src="{*[local-name()='icon']}" class="icon" />	
		</xsl:if>
		<xsl:choose>
			<xsl:when test="boolean(*[local-name()='link'])">
				<div class="feedtitle">
					<xsl:choose>
						<xsl:when test="boolean(*[local-name()='link']/@href)">
							<a href="{*[local-name()='link']/@href}">
								<xsl:value-of select="*[local-name()='title']"/>
							</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{*[local-name()='link']}">
								<xsl:value-of select="*[local-name()='title']"/>
							</a>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div class="feedtitle">
					<xsl:value-of select="*[local-name()='title']"/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<div class="subtitle">
			<xsl:value-of select="*[local-name()='description']"/>
			<xsl:value-of select="*[local-name()='subtitle']"/>
		</div>
		<xsl:apply-templates select="*[local-name()='item']|../*[local-name()='item']|*[local-name()='entry']"/>
	</div>
</xsl:template>

<xsl:template match="*[local-name()='image']">
	<xsl:if test="boolean(*[local-name()='url'])">
		<img src="{*[local-name()='url']}" class="icon" />
	</xsl:if>
</xsl:template>

<xsl:template match="*[local-name()='author']">
	<span class="author">
		<xsl:choose>
			<xsl:when test="boolean(text())">
				<xsl:value-of select="text()"/>
			</xsl:when>
			<xsl:when test="boolean(*[local-name()='name']|*[local-name()='email'])">
				<xsl:apply-templates select="*[local-name()='name']"/>
				<xsl:apply-templates select="*[local-name()='email']"/>
			</xsl:when>
		</xsl:choose>
	</span>
</xsl:template>

<xsl:template match="*[local-name()='name']">
	<xsl:value-of select="text()"/>
</xsl:template>

<xsl:template match="*[local-name()='email']">
	<xsl:value-of select="text()"/>
</xsl:template>

<xsl:template match="*[local-name()='item']|*[local-name()='entry']">
	<div class="entry">
		<xsl:choose>
			<xsl:when test="boolean(*[local-name()='link'])">
				<div class="entrytitle">
					<xsl:choose>
						<xsl:when test="boolean(*[local-name()='link']/@href)">
							<a href="{*[local-name()='link']/@href}"><xsl:value-of select="*[local-name()='title']" disable-output-escaping ="yes" /></a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{*[local-name()='link']}">
								<xsl:value-of select="*[local-name()='title']" disable-output-escaping ="yes" />
							</a>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<div class="entrytitle">
					<xsl:value-of select="*[local-name()='title']" disable-output-escaping ="yes" />
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<span class="date">
			<xsl:value-of select="*[local-name()='pubDate']|*[local-name()='updated']"/>
		</span>
		<xsl:apply-templates select="*[local-name()='author']" disable-output-escaping ="yes"/>
		<div class="entrycontent">
			<xsl:choose>
				<xsl:when test="boolean(*[local-name()='content']|*[local-name()='encoded'])">
					<xsl:value-of select="*[local-name()='content']" disable-output-escaping ="yes"/>
					<xsl:value-of select="*[local-name()='encoded']" disable-output-escaping ="yes"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="*[local-name()='description']" disable-output-escaping ="yes"/>
					<xsl:value-of select="*[local-name()='summary']" disable-output-escaping ="yes"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</div>
</xsl:template>

<!--
		Fallback
-->

<xsl:template match="*|text()">
</xsl:template>

</xsl:stylesheet>
