#import "AZTaskbarView.h"
#import "AZTask.h"
#import "AZFunctions.h"

@implementation AZTaskbarView

- (void) buttonAction: (id) sender
{
  Window win = (Window)[sender tag];
  BOOL iconified = AZIsWindowIconified(dpy, win);
//  NSLog(@"win %d, iconified %d", win, iconified);
  if (iconified)
  {
    XMapWindow(dpy, win);
    XSetInputFocus(dpy, win, RevertToNone, CurrentTime);
    return;
  }
  /* Not iconfied, check focus */
  Window focus_win;
  int rev;
  XGetInputFocus(dpy, &focus_win, &rev);
  if (focus_win != win)
  {
    XRaiseWindow(dpy, win);
    XSetInputFocus(dpy, win, RevertToNone, CurrentTime);
  }
}

- (void) updateTasks
{
  /* reuse buttons */
  NSRect bounds = [self bounds];
  int i, count = [tasks count];
  int width = ((bounds.size.width-5)/count)-5;
  for (i = 0; i < count; i++)
  {
    NSButton *button;
    NSRect rect;
    if (i >= [buttonArray count])
    {
      rect = NSMakeRect(0, 0, 25, 50);
      button = [[NSButton alloc] initWithFrame: rect];
      [button setTarget: self];
      [button setAction: @selector(buttonAction:)];
      [buttonArray addObject: button];
      [self addSubview: button];
      DESTROY(button);
    }

    rect = NSMakeRect(5+(width+5)*i, 5, width, bounds.size.height-10);
    button = [buttonArray objectAtIndex: i];
    [button setFrame: rect];
    [button setTitle: [(AZTask*)[tasks objectAtIndex: i] name]];
    [button setTag: [[tasks objectAtIndex: i] xwindow]];
  }
  /* remove unused buttons from superview */
  for (i = count; i < [buttonArray count]; i++)
  {
    [[buttonArray  objectAtIndex: i] removeFromSuperview];
  }

  [self display];
}

- (void) setTasks: (NSArray *) t
{
  ASSIGN(tasks, t);
  [self updateTasks];
}

- (id) initWithFrame: (NSRect) frame
{
  self = [super initWithFrame: frame];
  buttonArray = [[NSMutableArray alloc] init];
  return self;
}

- (void) dealloc
{
  DESTROY(buttonArray);
  [super dealloc];
}

@end
