#import "AZWindow.h"
#import "AZFunctions.h"

@implementation AZWindow
- (id) initWithContentRect: (NSRect)contentRect
                 styleMask: (unsigned int)aStyle
                   backing: (NSBackingStoreType)bufferingType
                     defer: (BOOL)flag
                    screen: (NSScreen*)aScreen
{
  self = [super initWithContentRect: contentRect
                 styleMask: aStyle
                   backing: bufferingType
                     defer: flag
                    screen: aScreen];

  server = GSCurrentServer();

  return self;
}

- (Window) xwindow
{
  if (!win)
  {
    void *winptr = [server windowDevice: [self windowNumber]];
    win = *(Window *)winptr;
  }
  return win;
}

- (void) becomeSticky
{
  /* stay in all desktops */
  AZSendClientMessage(dpy, [self xwindow], AZ_NET_WM_DESKTOP, 0xFFFFFFFF, 0, 0, 0, 0);
  /* and in case window manager is not running */
  unsigned int value = 0xFFFFFFFF;
  XChangeProperty(dpy, [self xwindow], AZ_NET_WM_DESKTOP, XA_CARDINAL, 32,
                  PropModeReplace, (unsigned char*) &value, 1);

  Atom state[3];
  state[0] = AZ_NET_WM_STATE_SKIP_PAGER;
  state[1] = AZ_NET_WM_STATE_SKIP_TASKBAR;
  state[2] = AZ_NET_WM_STATE_STICKY;
  XChangeProperty(dpy, [self xwindow], AZ_NET_WM_STATE, XA_ATOM, 32,
                  PropModeReplace, (unsigned char *) state, 3);
}

- (void) becomeDock
{
  Atom a = AZ_NET_WM_WINDOW_TYPE_DOCK;
  XChangeProperty(dpy, [self xwindow], AZ_NET_WM_WINDOW_TYPE, XA_ATOM, 32,
                  PropModeReplace, (unsigned char *) &a, 1);
}

@end
