#import "AZPager.h"
#import "AZTask.h"
#import "AZPagerView.h"
#import "AZFunctions.h"
#import "AZPagerWindow.h"
#import <GNUstepGUI/GSDisplayServer.h>
#import <X11/Xatom.h>
#import <X11/Xutil.h>

@interface GSDisplayServer (AZPrivate)
- (void) processEvent: (XEvent *) event;
@end

static AZPager *sharedInstance;

@implementation AZPager

- (void) readClientListStacking
{
  int count = AZNumberOfDesktops(dpy);
  int index = AZCurrentDesktop(dpy);
  if (count < 0) count = 1;
  // FIXME: should I check maximal ?
  if (index >= count) index = 0;

  Window *win;
  int i, wcount;

  [tasks removeAllObjects];
  win = AZGetPropertyData(dpy, root_win, AZ_NET_CLIENT_LIST_STACKING,
		          XA_WINDOW, &wcount);

  if ((win == NULL) || (wcount == 0))
    return;

  for (i = 0; i < wcount; i++)
  {
    if (AZIsMyWindow(dpy, win[i]) == YES)
      continue;

    AZTask *task = [[AZTask alloc] initWithXWindow: win[i]];
    [tasks addObject: task];
    DESTROY(task);

    /* Listen to change on client */
    XSelectInput(dpy, win[i], 
		 (PropertyChangeMask|StructureNotifyMask));
  }
  [panelView setTasks: tasks];
}

- (void) handleDestroyNotify: (XEvent *) event
{
  NSLog(@"Destroy: %d", event->xdestroywindow.window);
}

- (void) handlePropertyNotify: (XEvent *) event
{
  Window win = event->xproperty.window;  
  Atom atom = event->xproperty.atom;

  if (win == root_win)
  {
    if (atom == AZ_NET_CLIENT_LIST_STACKING)
    {
      [self readClientListStacking];
    }
    return;
  }
}

- (void) handleFocusInNotify: (XEvent *) event
{
#if 0
  char *wm_class, *wm_instance;
  if (AZGetWindowClass(dpy, event->xfocus.window, &wm_class, &wm_instance))
  {
    NSLog(@"Focus in: %s.%s (%d)", wm_instance, wm_class, event->xfocus.window);
  }
  else
  {
    NSLog(@"Focus in: %d", event->xfocus.window);
  }
#endif
}

- (void)receivedEvent:(void *)data
                 type:(RunLoopEventType)type
                extra:(void *)extra
              forMode:(NSString *)mode
{
  XEvent event;

  while (XPending(dpy)) 
  {
    XNextEvent (dpy, &event);
    switch (event.type) {
      case Expose:
	/* This is only for AZPager.
	 * Make sure main window is focused (appicon may has the focus).
	 */
	[panelWindow becomeMainWindow];
	[server processEvent: &event];
        break;
      case DestroyNotify:
	/* If main window is not [NSWindow mainWindow],
	 * this may be called. Therefore, we need to terminate manually.
	 */
	if (mainXWindow == event.xdestroywindow.window)
	  [NSApp terminate: self];
	else
	  [self handleDestroyNotify: &event];
	break;
      case PropertyNotify:
	if (AZIsMyWindow(dpy, event.xproperty.window) == YES)
	  [server processEvent: &event];
	else
	  [self handlePropertyNotify: &event];
	break;
#if 0
      case FocusIn:
	if (AZIsMyWindow(dpy, event.xfocus.window) == YES)
	  [server processEvent: &event];
	else
	  [self handleFocusInNotify: &event];
	break;
#endif
      default:
	[server processEvent: &event];
    }
  }
  [panelWindow setContentSize: [panelView optimalSize]];
}

- (void) applicationWillFinishLaunching:(NSNotification *)aNotification
{
  tasks = [[NSMutableArray alloc] init];

  server = GSCurrentServer();

  AZInitializeXWindowSystem();

  /* Listen event */
  NSRunLoop     *loop = [NSRunLoop currentRunLoop];
  int xEventQueueFd = XConnectionNumber(dpy);

  [loop addEvent: (void*)(gsaddr)xEventQueueFd
                        type: ET_RDESC
                     watcher: (id<RunLoopEvents>)self
                     forMode: NSDefaultRunLoopMode];

  /* Listen to window closing and opening */
  XSelectInput(dpy, root_win, PropertyChangeMask);
}

- (void) applicationDidFinishLaunching:(NSNotification *)aNotification
{
  /* Setup user interface */
  int number = AZNumberOfDesktops(dpy);
  NSSize size;
  NSRect rect = NSMakeRect(100, 100, 50, 50);
  panelView = [[AZPagerView alloc] initWithFrame: rect];
  [panelView setNumberOfDesktops: number];
  size = [panelView optimalSize];
  rect = NSMakeRect(100, 100, size.width, size.height);
  panelWindow = [[AZPagerWindow alloc] initWithContentRect: rect
	                     styleMask: NSTitledWindowMask|NSClosableWindowMask
		             backing: NSBackingStoreBuffered
			     defer: YES];
  [panelWindow setContentView: panelView];
  [panelWindow setTitle: @"AZPager"];
  [panelWindow orderFront: self];

  /* Cache main window because if it is closed (destroyed),
   * any attempt to get xwindow from main window (NSWindow) 
   * causes segment fault.
   */
  mainXWindow = [panelWindow xwindow];
  if (mainXWindow == 0)
  {
    NSLog(@"Internal Error: cannot get mainXWindow");
  }

  /* stay in all desktops */
  [panelWindow becomeSticky];

  [self readClientListStacking];
}

- (BOOL) applicationShouldTerminateAfterLastWindowClosed: (id) sender
{
  return YES;
}

- (void) dealloc
{
  DESTROY(tasks);
  DESTROY(panelView);
  DESTROY(panelWindow);
  [super dealloc];
}

+ (AZPager *) sharedPager
{
  if (sharedInstance == nil)
    sharedInstance = [[AZPager alloc] init];
  return sharedInstance;
}

@end

