#ifndef __LUCENE_INDEX_COMPOUND_FILE_READER__
#define __LUCENE_INDEX_COMPOUND_FILE_READER__

#include "LuceneKit/Store/LCDirectory.h"
#include <Foundation/Foundation.h>

@interface LCFileEntry: NSObject
{
	long offset;
	long length;
}

@end

@interface LCCSIndexInput: LCIndexInput
{
	LCIndexInput *base;
	long fileOffset;
	long length;
}
- (id) initWithIndexInput: (LCIndexInput *) base offset: (long) fileOffset
       length: (long) length;
@end

@interface LCCompoundFileReader: NSObject <LCDirectory>
{
	id <LCDirectory> directory;
	NSString *fileName;
	LCIndexInput *stream;
	NSMutableDictionary *entries;
}
- (id) initWithDirectory: (id <LCDirectory>) dir
       name: (NSString *) name;
- (id <LCDirectory>) directory;
- (NSString *) name;
- (void) close;
- (LCIndexInput *) openInput: (NSString *) id;
- (NSArray *) list;
- (BOOL) fileExists: (NSString *) name;
- (NSTimeInterval) fileModified: (NSString *) name;
- (void) touchFile: (NSString *) name;
- (void) deleteFile: (NSString *) name;
- (void) renameFile: (NSString *) from to: (NSString *) to;
- (long) fileLength: (NSString *) name;
- (LCIndexOutput *) createOutput: (NSString *) name;
//- makeLock: (NSString *) name;

@end

#endif /* __LUCENE_INDEX_COMPOUND_FILE_READER__ */
