#ifndef __LUCENE_COMPOUND_FILE_WRITER__
#define __LUCENE_COMPOUND_FILE_WRITER__

#include <Foundation/Foundation.h>

@interface LCFileEntry: NSObject
{
	NSString *file;
	long directoryOffset;
	long dataOffset;
}
@end

@interface LCCompoundFileWriter: NSObject
{
	id <LCDirectoryL> directory;
	NSString *fileName;
	NSMutableDictionary *ids;
	NSMutableArray *entries;
	BOOL merged;
}

- (id) initWithDirectory: (id <LCDirectory>) dir name: (NSString *) name;
- (id <LCDirectory>) directory;
- (NSString *) getName;
- (void) addFile: (NSString *) file;
- (void) close;
- (void) copyFile: (LCFileEntry *) source indexOutput: (LCIndexOutput *) os
             data: (NSData *) buffer;

@end

#endif /* __LUCENE_COMPOUND_FILE_WRITER__ */
